<?= get_header(); ?>
<link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/single-blog.css">
<link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/single-blog.css">

<?php $b = get_field('blog'); ?>
<?php $relblogs = new WP_Query(array('post_type'=>'blog','posts_per_page'=>4,'post__not_in'=>array(get_the_ID()))); ?>

<section class="single-blg">
    <div class="container">
        <div class="row">
            <div class="col-lg-7">
                <?php createBreadcrumb(); ?>
                <div class="title"><?= get_the_title(); ?></div>
                <?php if(!empty($b['text'])): ?>
                    <div class="text"><?= $b['text']; ?></div>
                <?php endif; ?>
            </div>
            <div class="col-lg-5">
                <div class="img">
                    <?php if(!empty($b['img'])): ?>
                        <img src="<?= esc_url($b['img']['url']); ?>" loading="lazy" alt="<?= esc_attr($b['img']['alt']); ?>">
                    <?php endif; ?>
                </div>
                <?php if($relblogs->have_posts()): ?>
                    <div class="relbox">
                        <div class="rtitle">Outros artigos</div>
                        <div class="relbs">
                            <?php while($relblogs->have_posts()): $relblogs->the_post(); $bb = get_field('blog'); ?>
                                <div class="relb">
                                    <div class="imgg">
                                        <?php if(!empty($bb['img'])): ?>
                                            <img src="<?= esc_url($bb['img']['url']); ?>" loading="lazy" alt="<?= esc_attr($bb['img']['alt']); ?>">
                                        <?php endif; ?>
                                    </div>
                                    <div>
                                        <div class="tit"><?= get_the_title(); ?></div>
                                        <a href="<?= get_the_permalink(); ?>" class="md">Ver mais detalhes</a>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<?= get_footer(); ?>

<script>
    for(let i of document.querySelectorAll('.sticky .menu>*')){
        if(i.firstChild.text=='Blog'){
            i.classList.add('current-menu-item');
        }
    }
</script>