<?php /** Template Name: Trabalhe Conosco */ ?>
<?= get_header(); ?>
<link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/trabalhe-conosco.css">
<link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/trabalhe-conosco.css">

<?php $wwu = get_field('wwu'); ?>

<section class="wwu">
    <div class="container">
        <?php if(!empty($wwu['uptitle'])): ?>
            <div class="uptitle"><?= $wwu['uptitle']; ?></div>
        <?php endif; ?>
        <?php if(!empty($wwu['text'])): ?>
            <div class="text main"><?= $wwu['text']; ?></div>
        <?php endif; ?>
        <hr>
        <div class="row">
            <div class="col-lg-6">
                <div class="form">
                    <?= do_shortcode('[contact-form-7 id="f14b0de" title="Trabalhe Conosco"]'); ?>
                </div>
            </div>
            <div class="col-lg-6">
                <?php if(!empty($wwu['vagas'])): ?>
                    <div class="areas">
                        <div class="area">
                            <?php if(!empty($wwu['title'])): ?>
                                <div class="title"><?= $wwu['title']; ?></div>
                            <?php endif; ?>
                            <div class="boxes">
                                <?php foreach($wwu['vagas'] as $vg): ?>
                                    <div class="box">
                                        <?php if(!empty($vg['title'])): ?>
                                            <div class="tit"><?= $vg['title']; ?></div>
                                        <?php endif; ?>
                                        <?php if(!empty($vg['text'])): ?>
                                            <div class="text"><?= $vg['text']; ?></div>
                                        <?php endif; ?>
                                        <?php if(!empty($vg['link'])): ?>
                                            <a href="<?= !empty($vg['link']) ? $vg['link'] : ''; ?>" target="_blank" aria-label="Link para a Página <?= !empty($vg['link']) ? $vg['link'] : ''; ?>" class="dbtn"><p>Ver completo</p></a>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<?= get_footer(); ?>

<script>
    document.addEventListener('DOMContentLoaded',()=>{
        const dropArea = document.querySelector('.wwu .form .curriculum');
        const fileInput = document.querySelector('.wwu .form .curriculum input[type="file"][name="curriculum"]');
        let desc = document.querySelector('.wwu .form .curriculum .name');

        if (!dropArea || !fileInput) return;

        // Prevent default drag behaviors
        ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
            dropArea.addEventListener(eventName, e => e.preventDefault(), false);
            dropArea.addEventListener(eventName, e => e.stopPropagation(), false);
        });

        // Optional: visual feedback
        dropArea.addEventListener('dragover', () => {
            dropArea.classList.add('dragging');
        });

        dropArea.addEventListener('dragleave', () => {
            dropArea.classList.remove('dragging');
        });

        dropArea.addEventListener('click',() => {
            fileInput.click();
        });

        dropArea.addEventListener('drop', event => {
            dropArea.classList.remove('dragging');
            
            const files = event.dataTransfer.files;
            if (files.length > 0) {
                // Create a DataTransfer to assign files to input
                const dataTransfer = new DataTransfer();
                dataTransfer.items.add(files[0]);
                fileInput.files = dataTransfer.files;
                
                // Optional: Trigger change event
                fileInput.dispatchEvent(new Event('change'));
            }
        });

        fileInput.addEventListener('change',()=>{
            if(fileInput.value){
                desc.textContent = fileInput.value.replace('C:\\fakepath\\','');
            }else{
                desc.textContent = 'Arraste ou solte seu currículo aqui';
            }
        });
    });
</script>