<?php /** Template Name: Sustentabilidade */ ?>
<?= get_header(); ?>
<link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/sustentabilidade.css">
<link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/sustentabilidade.css">

<?php $sus = get_field('sus'); ?>
<?php $praticas = get_field('praticas'); ?>
<?php $respeito = get_field('respeito'); ?>

<section class="sustentabilidade">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <?php if(!empty($sus['sectitle'])): ?>
                    <div class="sectitle g"><?= $sus['sectitle']; ?></div>
                <?php endif; ?>
                <?php if(!empty($sus['text'])): ?>
                    <div class="text g"><?= $sus['text']; ?></div>
                <?php endif; ?>
            </div>
            <div class="col-lg-6">
                <div class="img ms-lg-auto">
                    <?php if(!empty($sus['img1'])): ?>
                        <img src="<?= esc_url($sus['img1']['url']); ?>" loading="lazy" alt="<?= esc_attr($sus['img1']['alt']); ?>">
                    <?php endif; ?>
                    <?php if(!empty($sus['img2'])): ?>
                        <img src="<?= esc_url($sus['img2']['url']); ?>" loading="lazy" alt="<?= esc_attr($sus['img2']['alt']); ?>">
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="praticas">
    <?php if(!empty($praticas['sectitle'])): ?>
        <div class="df">
            <div class="sectitle g"><?= $praticas['sectitle']; ?></div>
        </div>
    <?php endif; ?>
    <?php if(!empty($praticas['prts'])): ?>
        <div class="container">
            <div class="row">
                <?php foreach($praticas['prts'] as $pr): ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="box">
                            <?php if(!empty($pr['icon'])): ?>
                                <img src="<?= esc_url($pr['icon']['url']); ?>" loading="lazy" alt="<?= esc_attr($pr['icon']['alt']); ?>">
                            <?php endif; ?>
                            <div>
                                <?php if(!empty($pr['title'])): ?>
                                    <div class="title"><?= $pr['title']; ?></div>
                                <?php endif; ?>
                                <?php if(!empty($pr['text'])): ?>
                                    <div class="text"><?= $pr['text']; ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</section>

<section class="respeito">
    <div class="container">
        <div class="box">
            <?php if(!empty($respeito['sectitle'])): ?>
                <div class="sectitle g"><?= $respeito['sectitle']; ?></div>
            <?php endif; ?>
            <?php if(!empty($respeito['text'])): ?>
                <div class="text g"><?= $respeito['text']; ?></div>
            <?php endif; ?>
            <?php if(!empty($respeito['downs'])): ?>
                <div class="row">
                    <?php foreach($respeito['downs'] as $down): ?>
                        <div class="col-md-6">
                            <div class="bx">
                                <?php if(!empty($down['icon'])): ?>
                                    <img src="<?= esc_url($down['icon']['url']); ?>" loading="lazy" alt="<?= esc_attr($down['icon']['alt']); ?>">
                                <?php endif; ?>
                                <div>
                                    <?php if(!empty($down['title'])): ?>
                                        <div class="title"><?= $down['title']; ?></div>
                                    <?php endif; ?>
                                    <?php if(!empty($down['arq'])): ?>
                                        <a href="<?= $down['arq']; ?>" download class="down">Download</a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<?= get_footer(); ?>