<?php /** Template Name: Qualidade */ ?>
<?= get_header(); ?>
<link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/qualidade.css">
<link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/qualidade.css">

<?php $qualidade = get_field('qualidade'); ?>

<section class="qualidade">
    <div class="container">
        <?php if(!empty($qualidade['sectitle'])): ?>
            <div class="sectitle"><?= $qualidade['sectitle']; ?></div>
        <?php endif; ?>
        <?php if(!empty($qualidade['text'])): ?>
            <div class="text"><?= $qualidade['text']; ?></div>
        <?php endif; ?>
        <?php if(!empty($qualidade['pilars'])): ?>
            <div class="options">
                <?php foreach($qualidade['pilars'] as $pil): ?>
                    <div class="option"><?= !empty($pil['title']) ? $pil['title'] : ''; ?></div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <?php if(!empty($qualidade['arqs'])): ?>
            <div class="row">
                <?php foreach($qualidade['arqs'] as $arq): ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="box">
                            <?php if(!empty($arq['icon'])): ?>
                                <img src="<?= esc_url($arq['icon']['url']); ?>" loading="lazy" alt="<?= esc_attr($arq['icon']['alt']); ?>">
                            <?php endif; ?>
                            <div>
                                <?php if(!empty($arq['title'])): ?>
                                    <div class="title"><?= $arq['title']; ?></div>
                                <?php endif; ?>
                                <?php if(!empty($arq['arq'])): ?>
                                    <a href="<?= $arq['arq'] ?>" download class="down">Download</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<?= get_footer(); ?>