<?php /** Template Name: Home */ ?>
<?= get_header(); ?>
<link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/home.css">
<link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/home.css">

<?php $banners = get_field('banners'); ?>
<?php $destaques = get_field('destaques'); ?>
<?php $aboutus = get_field('aboutus'); ?>
<?php $bignumbers = get_field('bignumbers'); ?>
<?php $solucoes = get_field('solucoes'); ?>
<?php $qualidade = get_field('qualidade'); ?>
<?php $sustentabilidade = get_field('sustentabilidade'); ?>
<?php $blog = get_field('blog'); ?>
<?php $contato = get_field('contato'); ?>
<?php $wwu = get_field('wwu'); ?>

<?php if(!empty($banners)): ?>
    <section class="banners">
        <div class="owl-carousel owl-loaded owl-drag">
            <?php foreach($banners as $ban): ?>
                <div class="item" style="background: url(<?= esc_url($ban['url']); ?>) no-repeat center/cover">
                </div>
            <?php endforeach; ?>
        </div>
    </section>
<?php endif; ?>

<section class="destaques">
    <div class="container">
        <?php if(!empty($destaques['uptitle'])): ?>
            <div class="uptitle"><?= $destaques['uptitle']; ?></div>
        <?php endif; ?>
        <?php if(!empty($destaques['dests'])): ?>
            <div class="owl-carousel owl-loaded owl-drag">
                <?php foreach($destaques['dests'] as $d): ?>
                    <div class="item">
                        <div class="box">
                            <?php if(!empty($d['title'])): ?>
                                <div class="title"><?= $d['title']; ?></div>
                            <?php endif; ?>
                            <a href="<?= $d['linktype']=='int'&&!empty($d['int']) ? $d['int'] : (!empty($d['ext']) ? $d['ext'] : ''); ?>" class="lm"></a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<section class="aboutus">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="img">
                    <?php if(!empty($aboutus['img'])): ?>
                        <img src="<?= esc_url($aboutus['img']['url']); ?>" loading="lazy" alt="<?= esc_attr($aboutus['img']['alt']); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6">
                <?php if(!empty($aboutus['uptitle'])): ?>
                    <div class="uptitle"><?= $aboutus['uptitle']; ?></div>
                <?php endif; ?>
                <?php if(!empty($aboutus['sectitle'])): ?>
                    <div class="sectitle"><?= $aboutus['sectitle']; ?></div>
                <?php endif; ?>
                <?php if(!empty($aboutus['text'])): ?>
                    <div class="text"><?= $aboutus['text']; ?></div>
                <?php endif; ?>
                <?php if(!empty($aboutus['difs'])): ?>
                    <div class="difs">
                        <?php foreach($aboutus['difs'] as $d): ?>
                            <div class="dif"><?= !empty($d['dif']) ? $d['dif'] : ''; ?></div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <?php if(!empty($aboutus['btn'])): ?>
                    <a href="<?= !empty($aboutus['link']) ? $aboutus['link'] : ''; ?>" aria-label="Link para a Página <?= !empty($aboutus['link']) ? $aboutus['link'] : ''; ?>" class="dbtn"><p><?= $aboutus['btn']; ?></p></a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<?php if(!empty($bignumbers)): ?>
    <section class="bignumbers">
        <div class="container">
            <div class="owl-carousel owl-loaded owl-drag">
                <?php foreach($bignumbers as $bn): ?>
                    <div class="item">
                        <div class="box">
                            <?php if(!empty($bn['text1'])): ?>
                                <div class="text t1"><?= $bn['text1']; ?></div>
                            <?php endif; ?>
                            <?php if(!empty($bn['num'])): ?>
                                <div class="title"><?= $bn['num']; ?></div>
                            <?php endif; ?>
                            <?php if(!empty($bn['text2'])): ?>
                                <div class="text t2"><?= $bn['text2']; ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<section class="solucoes">
    <div class="container">
        <?php if(!empty($solucoes['uptitle'])): ?>
            <div class="uptitle"><?= $solucoes['uptitle']; ?></div>
        <?php endif; ?>
        <?php if(!empty($solucoes['sectitle'])): ?>
            <div class="sectitle"><?= $solucoes['sectitle']; ?></div>
        <?php endif; ?>
        <?php if(!empty($solucoes['sols'])): ?>
            <div class="row">
                <?php foreach($solucoes['sols'] as $sol): ?>
                    <?php
                        $text = get_field('servico_text',$sol->ID);    
                        $icon = get_field('servico_icon',$sol->ID);    
                    ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="box">
                            <div class="title"><?= get_the_title($sol->ID); ?></div>
                            <?php if(!empty($text)): ?>
                                <div class="text"><?= strip_tags($text); ?></div>
                            <?php endif; ?>
                            <div class="df">
                                <a href="<?= get_the_permalink($sol->ID); ?>" class="lm"></a>
                                <?php if(!empty($icon)): ?>
                                    <img src="<?= esc_url($icon['url']); ?>" loading="lazy" alt="<?= esc_attr($icon['alt']); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <?php if(!empty($solucoes['btn'])): ?>
            <a href="<?= !empty($solucoes['link']) ? $solucoes['link'] : ''; ?>" aria-label="Link para a Página <?= !empty($solucoes['link']) ? $solucoes['link'] : ''; ?>" class="dbtn"><p><?= $solucoes['btn']; ?></p></a>
        <?php endif; ?>
    </div>
</section>

<section class="qualidade">
    <div class="box">
        <div class="container">
            <div class="row">
                <div class="col-lg-7">
                    <?php if(!empty($qualidade['uptitle'])): ?>
                        <div class="uptitle w"><?= $qualidade['uptitle']; ?></div>
                    <?php endif; ?>
                    <?php if(!empty($qualidade['sectitle'])): ?>
                        <div class="sectitle w"><?= $qualidade['sectitle']; ?></div>
                    <?php endif; ?>
                    <?php if(!empty($qualidade['text'])): ?>
                        <div class="text w"><?= $qualidade['text']; ?></div>
                    <?php endif; ?>
                    <div class="bx">
                        <?php if(!empty($qualidade['icon'])): ?>
                            <img src="<?= esc_url($qualidade['icon']['url']); ?>" loading="lazy" alt="<?= esc_attr($qualidade['icon']['alt']); ?>">
                        <?php endif; ?>
                        <?php if(!empty($qualidade['title'])): ?>
                            <div class="title"><?= $qualidade['title']; ?></div>
                        <?php endif; ?>
                        <?php if(!empty($qualidade['textt'])): ?>
                            <div class="txt"><?= $qualidade['textt']; ?></div>
                        <?php endif; ?>
                    </div>
                    <hr>
                    <?php if(!empty($qualidade['btn'])): ?>
                        <a href="<?= !empty($qualidade['link']) ? $qualidade['link'] : ''; ?>" aria-label="Link para a Página <?= !empty($qualidade['link']) ? $qualidade['link'] : ''; ?>" class="dbtn t"><p><?= $qualidade['btn']; ?></p></a>
                    <?php endif; ?>
                </div>
                <div class="col-lg-5">
                    <div class="img ms-lg-auto">
                        <?php if(!empty($qualidade['img'])): ?>
                            <img src="<?= esc_url($qualidade['img']['url']); ?>" loading="lazy" alt="<?= esc_attr($qualidade['img']['alt']); ?>">
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="sus">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <?php if(!empty($sustentabilidade['uptitle'])): ?>
                    <div class="uptitle g"><?= $sustentabilidade['uptitle']; ?></div>
                <?php endif; ?>
                <?php if(!empty($sustentabilidade['sectitle'])): ?>
                    <div class="sectitle g"><?= $sustentabilidade['sectitle']; ?></div>
                <?php endif; ?>
                <?php if(!empty($sustentabilidade['text'])): ?>
                    <div class="text g"><?= $sustentabilidade['text']; ?></div>
                <?php endif; ?>
                <?php if(!empty($sustentabilidade['btn'])): ?>
                    <a href="<?= !empty($sustentabilidade['link']) ? $sustentabilidade['link'] : ''; ?>" aria-label="Link para a Página <?= !empty($sustentabilidade['link']) ? $sustentabilidade['link'] : ''; ?>" class="dbtn g"><p><?= $sustentabilidade['btn']; ?></p></a>
                <?php endif; ?>
            </div>
            <div class="col-lg-6">
                <div class="img">
                    <?php if(!empty($sustentabilidade['img'])): ?>
                        <img src="<?= esc_url($sustentabilidade['img']['url']); ?>" loading="lazy" alt="<?= esc_attr($sustentabilidade['img']['alt']); ?>">
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $blogss = new WP_Query(array('post_type'=>'blog','posts_per_page'=>6,'orderby'=>'date','order'=>'DESC')); ?>

<section class="blog">
    <div class="container">
        <?php if(!empty($blog['uptitle'])): ?>
            <div class="uptitle"><?= $blog['uptitle']; ?></div>
        <?php endif; ?>
        <?php if(!empty($blog['sectitle'])): ?>
            <div class="sectitle"><?= $blog['sectitle']; ?></div>
        <?php endif; ?>
        <?php if($blogss->have_posts()): ?>
            <div class="owl-carousel owl-loaded owl-drag">
                <?php while($blogss->have_posts()): $blogss->the_post(); $bb = get_field('blog'); ?>
                    <div class="item">
                        <div class="box">
                            <div class="img">
                                <?php if(!empty($bb['img'])): ?>
                                    <img src="<?= esc_url($bb['img']['url']); ?>" loading="lazy" alt="<?= esc_attr($bb['img']['alt']); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="bottom">
                                <div class="title"><?= get_the_title(); ?></div>
                                <a href="<?= get_the_permalink(); ?>" class="lm"></a>
                            </div>
                        </div>
                    </div>
                <?php endwhile; wp_reset_postdata(); ?>
            </div>
        <?php endif; ?>
        <div class="df">
            <?php if(!empty($blog['btn'])): ?>
                <a href="<?= !empty($blog['link']) ? $blog['link'] : ''; ?>" aria-label="Link para a Página <?= !empty($blog['link']) ? $blog['link'] : ''; ?>" class="dbtn"><p><?= $blog['btn']; ?></p></a>
            <?php endif; ?>
        </div>
    </div>
</section>

<section class="contato">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <?php if(!empty($contato['uptitle'])): ?>
                    <div class="uptitle"><?= $contato['uptitle']; ?></div>
                <?php endif; ?>
                <?php if(!empty($contato['sectitle'])): ?>
                    <div class="sectitle"><?= $contato['sectitle']; ?></div>
                <?php endif; ?>
                <?php if(!empty($contato['text'])): ?>
                    <div class="text"><?= $contato['text']; ?></div>
                <?php endif; ?>
                <div class="conts">
                    <?php if(!empty($contato['tels'])): ?>
                        <div class="cont">
                            <div class="icon ctel">
                                <img src="<?= get_template_directory_uri(); ?>/assets/img/ctel.svg" loading="lazy" alt="">
                            </div>
                            <hr>
                            <div>
                                <div class="title">Telefones Comerciais</div>
                                <div class="df">
                                    <?php foreach($contato['tels'] as $tel): ?>
                                        <a href="<?= strlen(preg_replace('/\D/', '', $tel['tel']))>10 ? 'https://api.whatsapp.com/send?l=pt_br&amp;phone=55' : 'tel:55'; ?><?= preg_replace('/\D/', '', $tel['tel']); ?>" <?= strlen(preg_replace('/\D/', '', $tel['tel']))>10 ? 'target="_blank"' : ''; ?> class="telp" aria-label="<?= strlen(preg_replace('/\D/', '', $tel['tel']))>10 ? 'WhatsApp' : 'Telefone'; ?> <?= $tel['tel']; ?>" ><?= $tel['tel']; ?></a>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty($contato['zaps'])): ?>
                        <div class="cont">
                            <div class="icon czap">
                                <img src="<?= get_template_directory_uri(); ?>/assets/img/czap.svg" loading="lazy" alt="">
                            </div>
                            <hr>
                            <div>
                                <div class="title">WhatsApp</div>
                                <div class="df">
                                    <?php foreach($contato['zaps'] as $zap): ?>
                                        <a href="<?= strlen(preg_replace('/\D/', '', $zap['zap']))>10 ? 'https://api.whatsapp.com/send?l=pt_br&amp;phone=55' : 'tel:55'; ?><?= preg_replace('/\D/', '', $zap['zap']); ?>" <?= strlen(preg_replace('/\D/', '', $zap['zap']))>10 ? 'target="_blank"' : ''; ?> class="telp" aria-label="<?= strlen(preg_replace('/\D/', '', $zap['zap']))>10 ? 'WhatsApp' : 'Telefone'; ?> <?= $zap['zap']; ?>" ><?= $zap['zap']; ?></a>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty($contato['local'])): ?>
                        <div class="cont">
                            <div class="icon clocal">
                                <img src="<?= get_template_directory_uri(); ?>/assets/img/clocal.svg" loading="lazy" alt="">
                            </div>
                            <hr>
                            <div>
                                <div class="title">Endereço</div>
                                <div class="local"><?= $contato['local']; ?></div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <?php if(!empty($contato['mapa'])): ?>
                    <div class="mapa"><?= $contato['mapa']; ?></div>
                <?php endif; ?>
            </div>
            <div class="col-lg-6">
                <div class="form">
                    <?= do_shortcode('[contact-form-7 id="26199d4" title="Formulário de Contato"]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="wwu">
    <div class="container">
        <div class="box">
            <?php if(!empty($wwu['uptitle'])): ?>
                <div class="uptitle w"><?= $wwu['uptitle']; ?></div>
            <?php endif; ?>
            <?php if(!empty($wwu['sectitle'])): ?>
                <div class="sectitle w"><?= $wwu['sectitle']; ?></div>
            <?php endif; ?>
            <?php if(!empty($wwu['text'])): ?>
                <div class="text w"><?= $wwu['text']; ?></div>
            <?php endif; ?>
            <?php if(!empty($wwu['btn'])): ?>
                <a href="<?= !empty($wwu['link']) ? $wwu['link'] : ''; ?>" aria-label="Link para a Página <?= !empty($wwu['link']) ? $wwu['link'] : ''; ?>" class="dbtn t"><p><?= $wwu['btn']; ?></p></a>
            <?php endif; ?>
        </div>
    </div>
</section>

<?= get_footer(); ?>

<script>
    let maxHeight=0;
    document.querySelectorAll('.solucoes .box .title').forEach(function(e) {
    if (e.offsetHeight > maxHeight) {
        maxHeight = e.offsetHeight;
    }
    });
    document.querySelectorAll('.solucoes .box .title').forEach(function(e) {
        e.style.height = maxHeight + 'px';
    });
    maxHeight=0;
    document.querySelectorAll('.solucoes .box .text').forEach(function(e) {
    if (e.offsetHeight > maxHeight) {
        maxHeight = e.offsetHeight;
    }
    });
    document.querySelectorAll('.solucoes .box .text').forEach(function(e) {
        e.style.height = maxHeight + 'px';
    });
</script>

<script>
    window.addEventListener('load',()=>{
        setTimeout(() => {
            maxHeight=0;
            document.querySelectorAll('.bignumbers .box').forEach(function(e) {
            if (e.offsetHeight > maxHeight) {
                maxHeight = e.offsetHeight;
            }
            });
            document.querySelectorAll('.bignumbers .box').forEach(function(e) {
                e.style.height = maxHeight + 'px';
            });
        }, 200);
    })
</script>

<script>
    window.addEventListener('load',()=>{
        setTimeout(() => {
            maxHeight=0;
            document.querySelectorAll('.blog .box .title').forEach(function(e) {
            if (e.offsetHeight > maxHeight) {
                maxHeight = e.offsetHeight;
            }
            });
            document.querySelectorAll('.blog .box .title').forEach(function(e) {
                e.style.height = maxHeight + 'px';
            });
        }, 200);
    })
</script>