<?php /** Template Name: Contato */ ?>
<?= get_header(); ?>
<link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/contato.css">
<link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/contato.css">

<?php $contato = get_field('contato'); ?>

<section class="contato">
    <div class="container">
        <?php if(!empty($contato['uptitle'])): ?>
            <div class="uptitle"><?= $contato['uptitle']; ?></div>
        <?php endif; ?>
        <?php if(!empty($contato['text'])): ?>
            <div class="text"><?= $contato['text']; ?></div>
        <?php endif; ?>
        <hr>
        <div class="row">
            <?php if(!empty($contato['tels'])): ?>
                <div class="col-lg-4 col-md-6">
                    <div class="box tel">
                        <div class="sectitle">Telefones</div>
                        <div class="conts">
                            <?php foreach($contato['tels'] as $tel): ?>
                                <div class="df">
                                    <div class="tit"><?= !empty($tel['title']) ? $tel['title'] : ''; ?></div>
                                    <?php if(!empty($tel['telss'])): ?>
                                        <?php foreach($tel['telss'] as $tel): ?>
                                            <a href="<?= strlen(preg_replace('/\D/', '', $tel['tel']))>10 ? 'https://api.whatsapp.com/send?l=pt_br&amp;phone=55' : 'tel:55'; ?><?= preg_replace('/\D/', '', $tel['tel']); ?>" <?= strlen(preg_replace('/\D/', '', $tel['tel']))>10 ? 'target="_blank"' : ''; ?> class="telp" aria-label="<?= strlen(preg_replace('/\D/', '', $tel['tel']))>10 ? 'WhatsApp' : 'Telefone'; ?> <?= $tel['tel']; ?>" ><?= $tel['tel']; ?></a>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <img src="<?= get_template_directory_uri(); ?>/assets/img/pconttel.svg" loading="lazy" alt="">
                    </div>
                </div>
            <?php endif; ?>
            <?php if(!empty($contato['mails'])): ?>
                <div class="col-lg-4 col-md-6">
                    <div class="box mail">
                        <div class="sectitle">E-mail</div>
                        <div class="conts">
                            <?php foreach($contato['mails'] as $mail): ?>
                                <div class="df">
                                    <a href="mailto:<?= !empty($mail['mail']) ? $mail['mail'] : '' ?>" class="mailp" aria-label="E-mail <?= !empty($mail['mail']) ? $mail['mail'] : '' ?>"><?= !empty($mail['mail']) ? $mail['mail'] : '' ?></a>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <img src="<?= get_template_directory_uri(); ?>/assets/img/pcontmail.svg" loading="lazy" alt="">
                    </div>
                </div>
            <?php endif; ?>
            <?php if(!empty($contato['local'])): ?>
                <div class="col-lg-4 col-md-6">
                    <div class="box loc">
                        <div class="sectitle">Endereço</div>
                        <div class="conts">
                            <div class="df">
                                <div class="local"><?= $contato['local']; ?></div>
                            </div>
                        </div>
                        <img src="<?= get_template_directory_uri(); ?>/assets/img/pcontlocal.svg" loading="lazy" alt="">
                    </div>
                </div>
            <?php endif; ?>
            <div class="col-lg-7">
                <div class="form">
                    <?= do_shortcode('[contact-form-7 id="26199d4" title="Formulário de Contato"]'); ?>
                </div>
            </div>
            <div class="col-lg-5">
                <?php if(!empty($contato['mapa'])): ?>
                    <div class="mapa"><?= $contato['mapa']; ?></div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<?= get_footer(); ?>