<?php /** Template Name: Sobre Nós */ ?>
<?= get_header(); ?>
<link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/aboutus.css">
<link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/aboutus.css">

<?php $aboutus = get_field('aboutus'); ?>

<section class="aboutus">
    <div class="container">
        <div class="row">
            <div class="col-lg-7">
                <?php if(!empty($aboutus['text'])): ?>
                    <div class="text"><?= $aboutus['text']; ?></div>
                <?php endif; ?>
                <?php if(!empty($aboutus['difs'])): ?>
                    <div class="title">Diferenciais</div>
                    <ul class="difs">
                        <?php foreach($aboutus['difs'] as $d): ?>
                            <li><?= !empty($d['dif']) ? $d['dif'] : ''; ?></li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>
            <div class="col-lg-5">
                <div class="img">
                    <?php if(!empty($aboutus['img'])): ?>
                        <img src="<?= esc_url($aboutus['img']['url']); ?>" loading="lazy" alt="<?= esc_attr($aboutus['img']['alt']); ?>">
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?= get_footer(); ?>