<!DOCTYPE html>
<html lang="pt-BR" class="no-js" <?php language_attributes(); ?>>
<head>
    <!-- Icone -->
    <link rel="apple-touch-icon" sizes="57x57" href="<?= get_template_directory_uri() ?>/assets/img/icones/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="<?= get_template_directory_uri() ?>/assets/img/icones/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="<?= get_template_directory_uri() ?>/assets/img/icones/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="<?= get_template_directory_uri() ?>/assets/img/icones/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="<?= get_template_directory_uri() ?>/assets/img/icones/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="<?= get_template_directory_uri() ?>/assets/img/icones/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="<?= get_template_directory_uri() ?>/assets/img/icones/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="<?= get_template_directory_uri() ?>/assets/img/icones/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="<?= get_template_directory_uri() ?>/assets/img/icones/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192"  href="<?= get_template_directory_uri() ?>/assets/img/icones/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?= get_template_directory_uri() ?>/assets/img/icones/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="<?= get_template_directory_uri() ?>/assets/img/icones/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?= get_template_directory_uri() ?>/assets/img/icones/favicon-16x16.png">
    <link rel="manifest" href="<?= get_template_directory_uri() ?>/assets/img/icones/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?= get_template_directory_uri() ?>/assets/img/icones/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">

    <meta name="viewport" content="width=device-width,initial-scale=1">
    <?php $metaTags = get_field('meta_tags','options'); ?>

    <!-- Required meta tags -->
	<?php $pageTitle = empty($metaTags['titulo_da_pagina']) ? (is_single() ? get_the_title() : get_bloginfo('name').' '.get_bloginfo('description')) : $metaTags["titulo_da_pagina"] ?>
    <title><?= $pageTitle ?></title>
    <meta name="description" content="<?= !empty($metaTags['descricao']) ? $metaTags['descricao'] : (is_single() ? get_the_title() : get_bloginfo('name').' '.get_bloginfo('description')); ?>">
    <meta name="keywords" content="<?= !empty($metaTags['keywords']) ? $metaTags['keywords'] : (is_single() ? get_the_title() : get_bloginfo('name').' '.get_bloginfo('description')); ?>">
    <meta name="author" content="Visualy Publicidade">

    <!-- Metatags for social media -->
    <meta property="og:url" content="<?= is_single() ? get_the_permalink() : home_url($_SERVER['REQUEST_URI']) ?>">
    <meta property="og:type" content="<?= is_single() ? get_the_permalink() : home_url($_SERVER['REQUEST_URI']) ?>">
    <meta property="og:title" content="<?= $pageTitle ?>">
    <meta property="og:description" content="<?= !empty($metaTags['descricao']) ? $metaTags['descricao'] : (is_single() ? get_the_title() : get_bloginfo('name').' '.get_bloginfo('description')); ?>">
    <meta property="og:image" content="<?php get_template_directory_uri() ?>">

    <!-- Twitter Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta property="twitter:domain" content="<?= is_single() ? get_the_permalink() : home_url($_SERVER['REQUEST_URI']) ?>">
    <meta property="twitter:url" content="<?= is_single() ? get_the_permalink() : home_url($_SERVER['REQUEST_URI']) ?>">
    <meta name="twitter:title" content="<?= $pageTitle ?>">
    <meta name="twitter:description" content="<?= !empty($metaTags["descricao"]) ? $metaTags["descricao"] : (is_single() ? get_the_title() : get_bloginfo('name').' '.get_bloginfo('description')); ?>">
    <meta name="twitter:image" content="<?php get_template_directory_uri() ?>">
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?= get_template_directory_uri() ?>/assets/library/bootstrap/css/bootstrap.min.css">
    <link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/assets/library/bootstrap/css/bootstrap.min.css">

    <!-- Owl Caroussel -->
    <link rel="stylesheet" href="<?= get_template_directory_uri() ?>/assets/library/OwlCarousel/dist/assets/owl.carousel.min.css">
    <link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/assets/library/OwlCarousel/dist/assets/owl.carousel.min.css">

    <!-- Fonts -->
    <link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/fonts.css">
    <link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/fonts.css">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/header.css">
    <link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/header.css">
    
    <link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/footer.css">
    <link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/footer.css">
    
    <link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/helpers.css">
    <link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/helpers.css">

    <?php wp_head(); ?>
</head>
    <body <?php body_class(); ?>>
        <?php $header = get_field('header','options'); ?>
        <?php $wpp = get_field('wpp','options'); ?>

        <header class="sticky">
            <div class="container">
                <nav class="navbar navbar-expand-lg navbar-light">
                    <div class="navbar-brand">
                        <?= get_custom_logo(); ?>
                    </div>
                    <div class="headers">
                        <div class="header1">
                            <?php if(!empty($header['tels'])): ?>
                                <div class="df tels">
                                    <?php foreach($header['tels'] as $tel): ?>
                                        <a href="tel:55<?= preg_replace('/\D/', '', $tel['tel']); ?>" class="telp" aria-label="<?= strlen(preg_replace('/\D/', '', $tel['tel']))>10 ? 'WhatsApp' : 'Telefone'; ?> <?= $tel['tel']; ?>" ><?= $tel['tel']; ?></a>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                            <?php if(!empty($header['zaps'])): ?>
                                <div class="df zaps">
                                    <?php foreach($header['zaps'] as $zap): ?>
                                        <a href="https://api.whatsapp.com/send?l=pt_br&amp;phone=55<?= preg_replace('/\D/', '', $zap['zap']); ?>" class="telp zap" aria-label="<?= strlen(preg_replace('/\D/', '', $zap['zap']))>10 ? 'WhatsApp' : 'Telefone'; ?> <?= $zap['zap']; ?>" ><?= $zap['zap']; ?></a>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                            <?php if(!empty($header['mails'])): ?>
                                <div class="df mails">
                                    <?php foreach($header['mails'] as $mail): ?>
                                        <a href="mailto:<?= !empty($mail['mail']) ? $mail['mail'] : '' ?>" class="mailp" aria-label="E-mail <?= !empty($mail['mail']) ? $mail['mail'] : '' ?>"><?= !empty($mail['mail']) ? $mail['mail'] : '' ?></a>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="header2">
                            <?php wp_nav_menu(); ?>
                            <?php if(!empty($header['btn'])): ?>
                                <a href="<?= !empty($header['link']) ? $header['link'] : ''; ?>" aria-label="Link para a Página <?= !empty($header['link']) ? $header['link'] : ''; ?>" class="dbtn"><p><?= $header['btn']; ?></p></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <button type="button" class="navbar-toggler" data-bs-toggle="offcanvas" data-bs-target="#offcv" aria-label="Botão de menu para celular" aria-controls="offcv" aria-expanded="false">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                </nav>
            </div>
        </header>

        <?php if(!is_home()&&!is_front_page()): ?>
            <section class="ban" style="background: url(<?= get_template_directory_uri(); ?>/assets/img/banbg1.svg) no-repeat left center/auto,url(<?= get_template_directory_uri(); ?>/assets/img/banbg.png) repeat left center/auto 100%,linear-gradient(90deg, #0E2050 0%, #009FE3 66.49%, rgba(0, 159, 227, 0.30) 100%) no-repeat center/cover,url(<?= get_template_directory_uri(); ?>/assets/img/banbg2.png) no-repeat right center/auto 100%">
                <div class="container">
                    <div class="title"><?= getPageTitle(); ?></div>
                </div>
            </section>
        <?php endif; ?>

        <?php if(!empty($wpp)): ?>
            <a href="https://api.whatsapp.com/send?l=pt_br&amp;phone=55<?= preg_replace('/\D/','',$wpp); ?>" target="_blank" class="wpp" aria-label="WhatsApp">
                <svg xmlns="http://www.w3.org/2000/svg" width="22.314" height="22.314" viewBox="0 0 22.314 22.314"><path id="whatsapp" d="M18.972,35.242a11.061,11.061,0,0,0-17.4,13.343L0,54.314l5.862-1.539a11.024,11.024,0,0,0,5.285,1.345h0a10.987,10.987,0,0,0,7.82-18.877Zm-7.82,17.014a9.174,9.174,0,0,1-4.682-1.28l-.334-.2-3.477.911L3.586,48.3l-.219-.349a9.208,9.208,0,1,1,17.079-4.886A9.293,9.293,0,0,1,11.152,52.257Zm5.041-6.883c-.274-.139-1.634-.807-1.888-.9s-.438-.139-.623.139-.712.9-.877,1.086-.324.209-.6.07a7.521,7.521,0,0,1-3.76-3.287c-.284-.488.284-.453.812-1.509a.512.512,0,0,0-.025-.483c-.07-.139-.623-1.5-.852-2.052s-.453-.463-.623-.473-.344-.01-.528-.01a1.023,1.023,0,0,0-.737.344,3.1,3.1,0,0,0-.966,2.306,5.413,5.413,0,0,0,1.126,2.859,12.346,12.346,0,0,0,4.722,4.174,5.406,5.406,0,0,0,3.317.692,2.83,2.83,0,0,0,1.863-1.315,2.311,2.311,0,0,0,.159-1.315C16.651,45.578,16.466,45.508,16.192,45.373Z" transform="translate(0 -32)" fill="#fff"/></svg>
                <div class="t">WhatsApp</div>
            </a>
        <?php endif; ?>