<?php

function remove_posts_menu_for_non_admin_users(){
	if(!is_admin() || is_admin() && !current_user_can('administrator')){
		remove_menu_page('admin.php?page=wpcf7');
		remove_menu_page('admin.php?page=complianz');
		remove_menu_page('admin.php?page=wpseo_dashboard');
		remove_menu_page('admin.php?page=cptui_manage_post_types');
		remove_menu_page('admin.php?page=cerber-security');

		remove_menu_page('edit.php?post_type=acf-field-group');
		remove_menu_page('edit-comments.php');
		
		remove_menu_page('update-core.php');
		remove_menu_page('themes.php');
		remove_menu_page('users.php');
		remove_menu_page('tools.php');
		remove_menu_page('options-general.php');
	}
}
add_action('admin_menu', 'remove_posts_menu_for_non_admin_users');

function block_plugin_installation($response, $url) {
    $blocked_plugins = array(
        'three-column-screen-layout',
        'wp-file-manager'
    );

    if (strpos($url, 'plugin-install.php') !== false) {
        foreach ($blocked_plugins as $blocked) {
            if (strpos($url, $blocked) !== false) {
                wp_die('Installation of this plugin is not allowed.');
            }
        }
    }

    return $response;
}
add_filter('http_request_args', 'block_plugin_installation', 10, 2);


function block_specific_plugins($plugins) {
    $blocked_plugins = array(
        'three-column-screen-layout/three-column-screen-layout.php',
        'wp-file-manager/wp-file-manager.php'
    );

    foreach ($blocked_plugins as $blocked_plugin) {
        if (in_array($blocked_plugin, array_keys($plugins))) {
            unset($plugins[$blocked_plugin]);
            add_action('admin_notices', function () use ($blocked_plugin) {
                echo '<div class="notice notice-error"><p>Installation of the plugin ' . esc_html($blocked_plugin) . ' is not allowed.</p></div>';
            });
        }
    }

    return $plugins;
}
add_filter('all_plugins', 'block_specific_plugins');

define('RSS',array(
	'fb'=>array(
		'name'=>'Facebook',
		'svg'=>'<svg width="12" height="22" viewBox="0 0 12 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.79563 22V11.9811H11.3496L11.8779 8.05836H7.79563V5.55975C7.79563 4.42779 8.12725 3.65278 9.83548 3.65278H12V0.155454C10.9468 0.0481145 9.88824 -0.00371371 8.82905 0.000206791C5.68766 0.000206791 3.53085 1.82405 3.53085 5.17224V8.05103H0V11.9738H3.53856V22H7.79563Z" fill="white"/></svg>'
	),
	'tw'=>array(
		'name'=>'X (antigo twitter)',
		'svg'=>'<svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.2778 8.65483L19.7232 0H17.9587L11.4941 7.51469L6.33054 0H0.375L8.18319 11.3637L0.375 20.4394H2.1395L8.96659 12.5037L14.4195 20.4394H20.375L12.2773 8.65483H12.2778ZM9.86114 11.4637L9.06991 10.3321L2.7752 1.32824H5.48534L10.565 8.59479L11.3561 9.7263L17.9595 19.1716H15.2496L9.86114 11.4641V11.4637Z" fill="white"/></svg>'
	),
	'ig'=>array(
		'name'=>'Instagram',
		'svg'=>'<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.84422 0.978469C7.91947 0.928969 8.2623 0.917969 11.0013 0.917969C13.7403 0.917969 14.0831 0.929885 15.1575 0.978469C16.2318 1.02705 16.9651 1.19847 17.6068 1.44689C18.2787 1.7008 18.8883 2.09772 19.3925 2.61105C19.9058 3.1143 20.3018 3.72297 20.5548 4.3958C20.8041 5.03747 20.9746 5.7708 21.0241 6.8433C21.0736 7.92039 21.0846 8.26322 21.0846 11.0013C21.0846 13.7403 21.0727 14.0831 21.0241 15.1584C20.9756 16.2309 20.8041 16.9642 20.5548 17.6059C20.3018 18.2788 19.9051 18.8885 19.3925 19.3925C18.8883 19.9058 18.2787 20.3018 17.6068 20.5548C16.9651 20.8041 16.2318 20.9746 15.1593 21.0241C14.0831 21.0736 13.7403 21.0846 11.0013 21.0846C8.2623 21.0846 7.91947 21.0727 6.84422 21.0241C5.77172 20.9756 5.03839 20.8041 4.39672 20.5548C3.72381 20.3018 3.11414 19.9051 2.61014 19.3925C2.09715 18.8889 1.70017 18.2795 1.44689 17.6068C1.19847 16.9651 1.02797 16.2318 0.978469 15.1593C0.928969 14.0822 0.917969 13.7394 0.917969 11.0013C0.917969 8.2623 0.929885 7.91947 0.978469 6.84514C1.02705 5.7708 1.19847 5.03747 1.44689 4.3958C1.70055 3.72304 2.09783 3.11367 2.61105 2.61014C3.11434 2.09726 3.7234 1.70029 4.3958 1.44689C5.03747 1.19847 5.7708 1.02797 6.8433 0.978469H6.84422ZM15.0759 2.79347C14.0126 2.74489 13.6936 2.7348 11.0013 2.7348C8.30905 2.7348 7.99005 2.74489 6.92672 2.79347C5.94314 2.83839 5.40964 3.00247 5.05397 3.14089C4.58372 3.32422 4.2473 3.54147 3.89439 3.89439C3.55984 4.21985 3.30238 4.61606 3.14089 5.05397C3.00247 5.40964 2.83839 5.94314 2.79347 6.92672C2.74489 7.99005 2.7348 8.30905 2.7348 11.0013C2.7348 13.6936 2.74489 14.0126 2.79347 15.0759C2.83839 16.0595 3.00247 16.593 3.14089 16.9486C3.30222 17.3859 3.5598 17.7828 3.89439 18.1082C4.2198 18.4428 4.61672 18.7004 5.05397 18.8617C5.40964 19.0001 5.94314 19.1642 6.92672 19.2091C7.99005 19.2577 8.30814 19.2678 11.0013 19.2678C13.6945 19.2678 14.0126 19.2577 15.0759 19.2091C16.0595 19.1642 16.593 19.0001 16.9486 18.8617C17.4189 18.6784 17.7553 18.4611 18.1082 18.1082C18.4428 17.7828 18.7004 17.3859 18.8617 16.9486C19.0001 16.593 19.1642 16.0595 19.2091 15.0759C19.2577 14.0126 19.2678 13.6936 19.2678 11.0013C19.2678 8.30905 19.2577 7.99005 19.2091 6.92672C19.1642 5.94314 19.0001 5.40964 18.8617 5.05397C18.6784 4.58372 18.4611 4.2473 18.1082 3.89439C17.7827 3.55987 17.3865 3.30241 16.9486 3.14089C16.593 3.00247 16.0595 2.83839 15.0759 2.79347ZM9.71339 14.1097C10.4327 14.4091 11.2336 14.4495 11.9793 14.224C12.7251 13.9986 13.3694 13.5211 13.8023 12.8734C14.2351 12.2256 14.4297 11.4476 14.3527 10.6723C14.2757 9.89703 13.9319 9.17253 13.3801 8.62255C13.0283 8.27099 12.6029 8.0018 12.1346 7.83435C11.6663 7.66691 11.1667 7.60538 10.6718 7.6542C10.1768 7.70302 9.69886 7.86096 9.27229 8.11667C8.84572 8.37238 8.48115 8.71948 8.20483 9.133C7.92851 9.54651 7.74731 10.0161 7.67427 10.5081C7.60124 11 7.63819 11.5021 7.78246 11.978C7.92674 12.454 8.17474 12.892 8.50863 13.2606C8.84251 13.6292 9.25397 13.9192 9.71339 14.1097ZM7.33647 7.33647C7.81774 6.8552 8.3891 6.47343 9.01791 6.21297C9.64672 5.9525 10.3207 5.81844 11.0013 5.81844C11.6819 5.81844 12.3559 5.9525 12.9847 6.21297C13.6135 6.47343 14.1849 6.8552 14.6661 7.33647C15.1474 7.81774 15.5292 8.3891 15.7896 9.01791C16.0501 9.64672 16.1842 10.3207 16.1842 11.0013C16.1842 11.6819 16.0501 12.3559 15.7896 12.9847C15.5292 13.6135 15.1474 14.1849 14.6661 14.6661C13.6942 15.6381 12.3759 16.1842 11.0013 16.1842C9.62672 16.1842 8.30844 15.6381 7.33647 14.6661C6.36449 13.6942 5.81845 12.3759 5.81845 11.0013C5.81845 9.62672 6.36449 8.30844 7.33647 7.33647ZM17.3336 6.5903C17.4529 6.4778 17.5484 6.34251 17.6144 6.19244C17.6805 6.04238 17.7157 5.88059 17.7181 5.71665C17.7205 5.55272 17.69 5.38997 17.6283 5.23804C17.5667 5.08612 17.4752 4.9481 17.3593 4.83217C17.2433 4.71624 17.1053 4.62475 16.9534 4.56311C16.8015 4.50147 16.6387 4.47095 16.4748 4.47334C16.3108 4.47573 16.1491 4.51098 15.999 4.57702C15.8489 4.64306 15.7136 4.73854 15.6011 4.8578C15.3823 5.08975 15.2625 5.39783 15.2672 5.71665C15.2718 6.03548 15.4006 6.33994 15.626 6.56541C15.8515 6.79087 16.156 6.91959 16.4748 6.92424C16.7936 6.92889 17.1017 6.8091 17.3336 6.5903Z" fill="white"/></svg>'
	),
	'lk'=>array(
		'name'=>'Linkedin',
		'svg'=>'<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.28925C0 0.577125 0.59175 0 1.32187 0H16.6781C17.4082 0 18 0.577125 18 1.28925V16.7108C18 17.4229 17.4082 18 16.6781 18H1.32187C0.59175 18 0 17.4229 0 16.7108V1.28925ZM5.56087 15.0682V6.94012H2.85975V15.0682H5.56087ZM4.21088 5.82975C5.1525 5.82975 5.73862 5.2065 5.73862 4.42575C5.72175 3.62812 5.15363 3.02175 4.22888 3.02175C3.30413 3.02175 2.7 3.62925 2.7 4.42575C2.7 5.2065 3.28612 5.82975 4.19287 5.82975H4.21088ZM9.73238 15.0682V10.5289C9.73238 10.2859 9.75037 10.0429 9.82238 9.86963C10.017 9.38475 10.4614 8.88188 11.2084 8.88188C12.186 8.88188 12.5764 9.62663 12.5764 10.7201V15.0682H15.2775V10.4062C15.2775 7.90875 13.9455 6.74775 12.168 6.74775C10.7347 6.74775 10.0924 7.53525 9.73238 8.08988V8.118H9.71438L9.73238 8.08988V6.94012H7.03237C7.06612 7.70288 7.03237 15.0682 7.03237 15.0682H9.73238Z" fill="white"/></svg>'
	),
	'yt'=>array(
		'name'=>'Youtube',
		'svg'=>'<svg width="26" height="18" viewBox="0 0 26 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.537 12.6942L16.9284 8.99977L10.537 5.30532V12.6942ZM24.773 3.05171C24.9331 3.63051 25.0439 4.40634 25.1178 5.39152C25.204 6.37671 25.2409 7.22643 25.2409 7.96532L25.3148 8.99977C25.3148 11.6967 25.1178 13.6794 24.773 14.9478C24.4651 16.0562 23.7508 16.7704 22.6425 17.0783C22.0637 17.2384 21.0046 17.3492 19.3791 17.4231C17.7781 17.5093 16.3127 17.5462 14.9581 17.5462L13 17.6201C7.84009 17.6201 4.62592 17.4231 3.3575 17.0783C2.24916 16.7704 1.5349 16.0562 1.22703 14.9478C1.06694 14.369 0.956107 13.5932 0.882218 12.608C0.796014 11.6228 0.759069 10.7731 0.759069 10.0342L0.685181 8.99977C0.685181 6.30282 0.882218 4.32014 1.22703 3.05171C1.5349 1.94338 2.24916 1.22912 3.3575 0.921246C3.93629 0.761154 4.99537 0.65032 6.62092 0.576431C8.22185 0.490228 9.68731 0.453283 11.0419 0.453283L13 0.379395C18.1599 0.379395 21.3741 0.576432 22.6425 0.921246C23.7508 1.22912 24.4651 1.94338 24.773 3.05171Z" fill="white"/></svg>'
	),
	'wp'=>array(
		'name'=>'WhatsApp',
		'svg'=>'<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15"><path id="whatsapp" d="M12.753,34.18a7.435,7.435,0,0,0-11.7,8.97L0,47l3.941-1.035a7.41,7.41,0,0,0,3.552.9h0a7.386,7.386,0,0,0,5.257-12.69ZM7.5,45.617a6.167,6.167,0,0,1-3.147-.861l-.224-.134-2.337.613.623-2.28-.147-.234a6.19,6.19,0,1,1,11.481-3.285A6.247,6.247,0,0,1,7.5,45.617Zm3.388-4.627c-.184-.094-1.1-.542-1.269-.6s-.295-.094-.419.094-.479.6-.589.73-.218.141-.4.047a5.056,5.056,0,0,1-2.528-2.21c-.191-.328.191-.3.546-1.015a.344.344,0,0,0-.017-.325c-.047-.094-.419-1.008-.573-1.379s-.3-.311-.419-.318S4.985,36,4.862,36a.688.688,0,0,0-.5.231,2.087,2.087,0,0,0-.65,1.55,3.639,3.639,0,0,0,.757,1.922,8.3,8.3,0,0,0,3.174,2.806,3.634,3.634,0,0,0,2.23.465,1.9,1.9,0,0,0,1.252-.884,1.553,1.553,0,0,0,.107-.884C11.193,41.127,11.069,41.08,10.885,40.99Z" transform="translate(0 -32)" fill="white"/></svg>'
	),
	'tl'=>array(
		'name'=>'Telegram',
		'svg'=>'<svg xmlns="http://www.w3.org/2000/svg" width="15" height="12" viewBox="0 0 15 12"><path id="telegram-plane" d="M14.974,65.492,12.71,75.675c-.171.719-.616.9-1.249.559L8.012,73.81,6.348,75.336a.881.881,0,0,1-.693.323L5.9,72.308l6.392-5.51c.278-.236-.06-.367-.432-.131l-7.9,4.747L.558,70.4c-.74-.22-.753-.706.154-1.045l13.307-4.89C14.635,64.243,15.175,64.594,14.974,65.492Z" transform="translate(-0.016 -64.399)" fill="white"/></svg>'
	),
	'pt'=>array(
		'name'=>'Pinterest',
		'svg'=>'<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15"><path id="pinterest" d="M15,15.5a7.5,7.5,0,0,1-9.72,7.164A8.431,8.431,0,0,0,6.212,20.7c.091-.351.466-1.784.466-1.784a2.009,2.009,0,0,0,1.718.862c2.262,0,3.892-2.081,3.892-4.666a4.4,4.4,0,0,0-4.624-4.331c-3.236,0-4.957,2.171-4.957,4.539a3.366,3.366,0,0,0,1.521,2.906c.142.067.218.036.251-.1.024-.1.151-.614.209-.85a.225.225,0,0,0-.051-.215,2.954,2.954,0,0,1-.553-1.712A3.246,3.246,0,0,1,7.47,12.095,2.961,2.961,0,0,1,10.6,15.146c0,2.029-1.025,3.435-2.359,3.435a1.088,1.088,0,0,1-1.11-1.355,15.07,15.07,0,0,0,.62-2.5.942.942,0,0,0-.95-1.055c-.753,0-1.358.777-1.358,1.821a2.7,2.7,0,0,0,.224,1.113s-.741,3.139-.877,3.726a7.26,7.26,0,0,0-.027,2.153A7.5,7.5,0,1,1,15,15.5Z" transform="translate(0 -8)" fill="white"/></svg>'
	),
	'sk'=>array(
		'name'=>'Skype',
		'svg'=>'<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15"><path id="skype" d="M14.223,40.969A7.289,7.289,0,0,0,14.38,39.5a6.873,6.873,0,0,0-6.875-6.875,7.08,7.08,0,0,0-1.467.157A3.746,3.746,0,0,0,.78,38.035,7.289,7.289,0,0,0,.623,39.5,6.873,6.873,0,0,0,7.5,46.377a7.079,7.079,0,0,0,1.467-.157A3.746,3.746,0,0,0,15,43.249a3.694,3.694,0,0,0-.777-2.281ZM7.706,44.033c-2.2,0-4.035-.978-4.035-2.177a.941.941,0,0,1,.988-1.025c1.045,0,1.142,1.5,2.95,1.5.861,0,1.417-.382,1.417-.881,0-.626-.536-.723-1.407-.938C5.526,40,3.674,39.78,3.674,37.6c0-1.983,1.962-2.716,3.654-2.716,1.845,0,3.711.733,3.711,1.855A1.009,1.009,0,0,1,10.023,37.8c-.948,0-.978-1.122-2.512-1.122-.861,0-1.407.234-1.407.754,0,.663.7.73,2.314,1.105,1.386.311,3.038.9,3.038,2.6,0,1.979-1.912,2.9-3.751,2.9Z" transform="translate(0 -32)" fill="white"/></svg>'
	)
));

function getRssName($select){
	return RSS[$select]['name'];
}

function getRss($select){
	return RSS[$select]['svg'];
}

function getPageTitle(){
	if(is_page()){
		return get_the_title();
	}elseif(is_tax()){
		return get_queried_object()->name;
	}elseif(is_archive()){
		return get_queried_object()->label;
	}elseif(is_single()){
		return get_post_type_object(get_queried_object()->post_type)->label;
	}
}

function createBreadcrumb(){
	echo '<div class="pathbox"><button class="back" onclick="javascript:history.go(-1)" style="background:none">Voltar</button><div class="path">';
	if(is_home()||is_front_page()){
		echo '<a href="'.site_url().'">Home</a>';
	}elseif(is_page()){
		echo '<a href="'.site_url().'">Home</a><div>'.get_queried_object()->post_title.'</div>';
	}elseif(is_tax('categorias')){
		echo '<a href="'.site_url().'">Home</a><a href="'.site_url('fun_e_tips').'">FUN & TIPS</a>';
	}elseif(is_archive()){
		echo '<a href="'.site_url().'">Home</a><a href="'.site_url(get_queried_object()->name).'">'.get_queried_object()->label.'</a>';
	}elseif(is_single()){
		echo '<a href="'.site_url().'">Home</a><a href="'.site_url(get_queried_object()->post_type).'">'.ucfirst(get_queried_object()->post_type).'</a><div>'.get_the_title().'</div>';
	}
	echo '</div></div>';
}

function embedYouTubeLink($link) {
	$regex = '/(?:youtube\.com\/(?:embed\/|v\/|watch\?v=|watch\?feature=player_embedded&v=|youtu\.be\/|watch\?v=|embed\?src_vid=))([\w\-]{11})/';
	preg_match($regex, $link, $match);
	if (!empty($match)) {
	  $videoId = $match[1];
	  $embedLink = 'https://www.youtube.com/embed/' . $videoId;
	  return $embedLink;
	} else {
	  return '';
	}
}

function custom_posts_per_page($query) {
    if (is_admin() || ! $query->is_main_query()) {
        return;
    }

    // Replace 'your_post_type' with the actual name of your custom post type
    
    if (is_post_type_archive('servicos')) {
        $query->set('orderby','menu_order');
		$query->set('order','ASC');
    }
}
add_action('pre_get_posts', 'custom_posts_per_page');

//FUNÇÃO DE CAMPOS ACF NO PAINEL

//  add_filter('manage_eventos_posts_columns', 'my_eventos_columns');
// function my_eventos_columns($columns) {
//     $columns['eve_dend'] = 'Data ACF';
//     return $columns;
// }

// add_action('manage_eventos_posts_custom_column',  'my_show_eventos_columns');
// function my_show_eventos_columns($name) {
//     global $post;
//     switch ($name) {
//         case 'eve_dend':
//             $views = get_post_meta($post->ID, 'eve_dend', true);
//             echo substr($views,-2).'/'.substr($views,-4,2).'/'.substr($views,0,4);
//     }
// }

//REMOVE <p> TAGS FROM CONTACT FORM
add_filter('wpcf7_autop_or_not', '__return_false');

function encurta($string, $length, $dots = "...") {
    return (strlen($string) > $length) ? substr($string, 0, $length - strlen($dots)) . $dots : $string;
}

function cut($string, $length, $dots = "") {
    return (strlen($string) > $length) ? substr($string, 0, $length - strlen($dots)) . $dots : $string;
}

if( function_exists('acf_add_options_page') ) {
    acf_add_options_page([
      'page_title' 	=> 'Informações Cabeçalho',
          'menu_title'	=> 'Informações Cabeçalho',
          'menu_slug' 	=> 'informacoes_cabecalho',
    ]);
}

if( function_exists('acf_add_options_page') ) {
    acf_add_options_page([
      'page_title' 	=> 'Informações Rodapé',
          'menu_title'	=> 'Informações Rodapé',
          'menu_slug' 	=> 'informacoes_rodape',
    ]);
}

if( function_exists('acf_add_options_page') ) {
    acf_add_options_page([
      'page_title' 	=> 'Whatsapp',
          'menu_title'	=> 'Whatsapp',
          'menu_slug' 	=> 'whatsapp',
    ]);
}

// Remove Posts menu from the admin dashboard
function remove_posts_menu() {
    remove_menu_page('edit.php'); // Removes "Posts"
    remove_menu_page('edit-comments.php'); // Removes "Comments"
}
add_action('admin_menu', 'remove_posts_menu');

// Redirect any user trying to access the posts or comments screens
function redirect_posts_comments(){
    global $pagenow;

    if($pagenow === 'edit-comments.php' || $pagenow === 'edit.php' && empty($_GET)){
        wp_redirect(admin_url());
        exit;
    }
}
add_action('admin_init', 'redirect_posts_comments');

// Disable post type and comments functionality
function disable_posts_and_comments() {
    remove_post_type_support('post', 'editor');
    remove_post_type_support('post', 'thumbnail');
    remove_post_type_support('post', 'excerpt');
    remove_post_type_support('post', 'comments');
}
add_action('init', 'disable_posts_and_comments');

function get_views($postID){
    $count_key = 'wpb_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}
//To keep the count accurate, lets get rid of prefetching
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);

function themeslug_query_vars( $qvars ) {
    $qvars[] = 'filter';
    return $qvars;
}
add_filter( 'query_vars', 'themeslug_query_vars' );


//PAGINAÇÃO

/* PAGINAÇÃO DO ARQUIVO */
function pagination($paged='',$max_page='') {
	if (!$paged) {
		$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
	}

	if (!$max_page) {
		global $wp_query;
		$max_page = intval($wp_query->max_num_pages);
	}
	if ($paged>=1)
		$links[] = $paged;

	/** Add the pages around the current page to the array */
	if ($paged>=3) {
		$links[] = $paged - 1;
		$links[] = $paged - 2;
	}
	if (($paged+2)<=$max_page) {
		$links[] = $paged + 2;
		$links[] = $paged + 1;
	}

	echo '<div class="pagination m-0 p-0 justify-content-center">'."\n";
	if(get_previous_posts_link()){
		echo get_previous_posts_link('<svg width="48" height="20" viewBox="0 0 48 20" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="8.5" cy="8.5" r="8.5" transform="matrix(-1 0 0 1 48 1.5)" fill="#009FE3" fill-opacity="0.2"/><path d="M44.5 10C33.9975 10 22.5025 10 2 10M2 10L12 1M2 10L12 19" stroke="url(#paint0_linear_1_2)" stroke-width="1.55"/><defs><linearGradient id="paint0_linear_1_2" x1="44.5" y1="10" x2="2" y2="10" gradientUnits="userSpaceOnUse"><stop stop-color="#0E2050"/><stop offset="1" stop-color="#009FE3"/></linearGradient></defs></svg>');
	}
	else{
		echo '<a href="'.$_SERVER['REQUEST_URI'].'" class="disabled"><svg width="48" height="21" viewBox="0 0 48 21" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="8.5" cy="8.5" r="8.5" transform="matrix(-1 0 0 1 48 2)" fill="#6C6C6C" fill-opacity="0.776471"/><path d="M44.5 10.5H2M2 10.5L12 1.5M2 10.5L12 19.5" stroke="#6C6C6C" stroke-opacity="0.6" stroke-width="1.55"/></svg></a>';
	}

	/** Link to first page, plus ellipses if necessary */
	if (!in_array(1,$links)) {
		$class = 1 == $paged ? ' class=""' : '';
		printf( '<a%s href="%s">%s</a>'."\n", $class,esc_url(get_pagenum_link(1)),'1');
		if (!in_array(2,$links))
			echo '<div>...</div>';
	}
	/** Link to current page, plus 2 pages in either direction if necessary */
	sort($links);
	foreach((array)$links as $link) {
		$class = $paged == $link ? ' class="active"' : '';
		printf('<a%s href="%s">%s</a>'."\n", $class,esc_url(get_pagenum_link($link)),$link);
	}
	/** Link to last page, plus ellipses if necessary */
	if (!in_array($max_page,$links)){
		if(!in_array($max_page-1,$links))
			echo '<div>...</div>'."\n";
		$class = $paged == $max_page ? '' : '';
		printf('<a%s href="%s">%s</a>'."\n",$class,esc_url(get_pagenum_link($max_page)), $max_page);
	}
	if(get_next_posts_link()){
		echo get_next_posts_link('<svg width="48" height="21" viewBox="0 0 48 21" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="8.5" cy="10.5" r="8.5" fill="#009FE3" fill-opacity="0.2"/><path d="M3.5 10.5C14.0025 10.5 25.4975 10.5 46 10.5M46 10.5L36 1.5M46 10.5L36 19.5" stroke="url(#paint0_linear_1_2)" stroke-width="1.55"/><defs><linearGradient id="paint0_linear_1_2" x1="3.5" y1="10.5" x2="46" y2="10.5" gradientUnits="userSpaceOnUse"><stop stop-color="#0E2050"/><stop offset="1" stop-color="#009FE3"/></linearGradient></defs></svg>');
	}else{
		echo '<a href="#" class="disabled"><svg width="48" height="20" viewBox="0 0 48 20" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="8.5" cy="10" r="8.5" fill="#6C6C6C" fill-opacity="0.776471"/><path d="M3.5 10H46M46 10L36 1M46 10L36 19" stroke="#6C6C6C" stroke-opacity="0.6" stroke-width="1.55"/></svg></a>';
	}
	echo '</div>' . "\n";
}

function twentytwenty_theme_support() {

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	// Custom background color.
	add_theme_support(
		'custom-background',
		array(
			'default-color' => 'f5efe0',
		)
	);

	// Set content-width.
	global $content_width;
	if ( ! isset( $content_width ) ) {
		$content_width = 580;
	}

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// Set post thumbnail size.
	set_post_thumbnail_size( 1200, 9999 );

	// Add custom image size used in Cover Template.
	add_image_size( 'twentytwenty-fullscreen', 1980, 9999 );

	// Custom logo.
	$logo_width  = 120;
	$logo_height = 90;

	// If the retina setting is active, double the recommended width and height.
	if ( get_theme_mod( 'retina_logo', false ) ) {
		$logo_width  = floor( $logo_width * 2 );
		$logo_height = floor( $logo_height * 2 );
	}

	add_theme_support(
		'custom-logo',
		array(
			'height'      => $logo_height,
			'width'       => $logo_width,
			'flex-height' => true,
			'flex-width'  => true,
		)
	);

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'script',
			'style',
			'navigation-widgets',
		)
	);

	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on Twenty Twenty, use a find and replace
	 * to change 'twentytwenty' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'twentytwenty' );

	// Add support for full and wide align images.
	add_theme_support( 'align-wide' );

	// Add support for responsive embeds.
	add_theme_support( 'responsive-embeds' );

	/*
	 * Adds starter content to highlight the theme on fresh sites.
	 * This is done conditionally to avoid loading the starter content on every
	 * page load, as it is a one-off operation only needed once in the customizer.
	 */
	if ( is_customize_preview() ) {
		require get_template_directory() . '/inc/starter-content.php';
		add_theme_support( 'starter-content', twentytwenty_get_starter_content() );
	}

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/*
	 * Adds `async` and `defer` support for scripts registered or enqueued
	 * by the theme.
	 */
	$loader = new TwentyTwenty_Script_Loader();
	add_filter( 'script_loader_tag', array( $loader, 'filter_script_loader_tag' ), 10, 2 );

}

add_action( 'after_setup_theme', 'twentytwenty_theme_support' );

/**
 * REQUIRED FILES
 * Include required files.
 */
require get_template_directory() . '/inc/template-tags.php';

// Handle SVG icons.
require get_template_directory() . '/classes/class-twentytwenty-svg-icons.php';
require get_template_directory() . '/inc/svg-icons.php';

// Handle Customizer settings.
require get_template_directory() . '/classes/class-twentytwenty-customize.php';

// Require Separator Control class.
require get_template_directory() . '/classes/class-twentytwenty-separator-control.php';

// Custom comment walker.
require get_template_directory() . '/classes/class-twentytwenty-walker-comment.php';

// Custom page walker.
require get_template_directory() . '/classes/class-twentytwenty-walker-page.php';

// Custom script loader class.
require get_template_directory() . '/classes/class-twentytwenty-script-loader.php';

// Non-latin language handling.
require get_template_directory() . '/classes/class-twentytwenty-non-latin-languages.php';

// Custom CSS.
require get_template_directory() . '/inc/custom-css.php';

// Block Patterns.
require get_template_directory() . '/inc/block-patterns.php';

/**
 * Register and Enqueue Styles.
 *
 * @since Twenty Twenty 1.0
 */
function twentytwenty_register_styles() {

	$theme_version = wp_get_theme()->get( 'Version' );

	wp_enqueue_style( 'twentytwenty-style', get_stylesheet_uri(), array(), $theme_version );
	wp_style_add_data( 'twentytwenty-style', 'rtl', 'replace' );

	// Add output of Customizer settings as inline style.
	wp_add_inline_style( 'twentytwenty-style', twentytwenty_get_customizer_css( 'front-end' ) );

	// Add print CSS.
	wp_enqueue_style( 'twentytwenty-print-style', get_template_directory_uri() . '/print.css', null, $theme_version, 'print' );

}

add_action( 'wp_enqueue_scripts', 'twentytwenty_register_styles' );

/**
 * Register and Enqueue Scripts.
 *
 * @since Twenty Twenty 1.0
 */
function twentytwenty_register_scripts() {

	$theme_version = wp_get_theme()->get( 'Version' );

	if ( ( ! is_admin() ) && is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	wp_enqueue_script( 'twentytwenty-js', get_template_directory_uri() . '/assets/js/index.js', array(), $theme_version, false );
	wp_script_add_data( 'twentytwenty-js', 'async', true );

}

add_action( 'wp_enqueue_scripts', 'twentytwenty_register_scripts' );

/**
 * Fix skip link focus in IE11.
 *
 * This does not enqueue the script because it is tiny and because it is only for IE11,
 * thus it does not warrant having an entire dedicated blocking script being loaded.
 *
 * @since Twenty Twenty 1.0
 *
 * @link https://git.io/vWdr2
 */
function twentytwenty_skip_link_focus_fix() {
	// The following is minified via `terser --compress --mangle -- assets/js/skip-link-focus-fix.js`.
	?>
	<script>
	/(trident|msie)/i.test(navigator.userAgent)&&document.getElementById&&window.addEventListener&&window.addEventListener("hashchange",function(){var t,e=location.hash.substring(1);/^[A-z0-9_-]+$/.test(e)&&(t=document.getElementById(e))&&(/^(?:a|select|input|button|textarea)$/i.test(t.tagName)||(t.tabIndex=-1),t.focus())},!1);
	</script>
	<?php
}
add_action( 'wp_print_footer_scripts', 'twentytwenty_skip_link_focus_fix' );

/**
 * Enqueue non-latin language styles.
 *
 * @since Twenty Twenty 1.0
 *
 * @return void
 */
function twentytwenty_non_latin_languages() {
	$custom_css = TwentyTwenty_Non_Latin_Languages::get_non_latin_css( 'front-end' );

	if ( $custom_css ) {
		wp_add_inline_style( 'twentytwenty-style', $custom_css );
	}
}

add_action( 'wp_enqueue_scripts', 'twentytwenty_non_latin_languages' );

/**
 * Register navigation menus uses wp_nav_menu in five places.
 *
 * @since Twenty Twenty 1.0
 */
function twentytwenty_menus() {

	$locations = array(
		'primary'  => __( 'Desktop Horizontal Menu', 'twentytwenty' ),
		'expanded' => __( 'Desktop Expanded Menu', 'twentytwenty' ),
		'mobile'   => __( 'Mobile Menu', 'twentytwenty' ),
		'footer'   => __( 'Footer Menu', 'twentytwenty' ),
		'social'   => __( 'Social Menu', 'twentytwenty' ),
	);

	register_nav_menus( $locations );
}

add_action( 'init', 'twentytwenty_menus' );

/**
 * Get the information about the logo.
 *
 * @since Twenty Twenty 1.0
 *
 * @param string $html The HTML output from get_custom_logo (core function).
 * @return string
 */
function twentytwenty_get_custom_logo( $html ) {

	$logo_id = get_theme_mod( 'custom_logo' );

	if ( ! $logo_id ) {
		return $html;
	}

	$logo = wp_get_attachment_image_src( $logo_id, 'full' );

	if ( $logo ) {
		// For clarity.
		$logo_width  = esc_attr( $logo[1] );
		$logo_height = esc_attr( $logo[2] );

		// If the retina logo setting is active, reduce the width/height by half.
		if ( get_theme_mod( 'retina_logo', false ) ) {
			$logo_width  = floor( $logo_width / 2 );
			$logo_height = floor( $logo_height / 2 );

			$search = array(
				'/width=\"\d+\"/iU',
				'/height=\"\d+\"/iU',
			);

			$replace = array(
				"width=\"{$logo_width}\"",
				"height=\"{$logo_height}\"",
			);

			// Add a style attribute with the height, or append the height to the style attribute if the style attribute already exists.
			if ( strpos( $html, ' style=' ) === false ) {
				$search[]  = '/(src=)/';
				$replace[] = "style=\"height: {$logo_height}px;\" src=";
			} else {
				$search[]  = '/(style="[^"]*)/';
				$replace[] = "$1 height: {$logo_height}px;";
			}

			$html = preg_replace( $search, $replace, $html );

		}
	}

	return $html;

}

add_filter( 'get_custom_logo', 'twentytwenty_get_custom_logo' );

if ( ! function_exists( 'wp_body_open' ) ) {

	/**
	 * Shim for wp_body_open, ensuring backward compatibility with versions of WordPress older than 5.2.
	 *
	 * @since Twenty Twenty 1.0
	 */
	function wp_body_open() {
		/** This action is documented in wp-includes/general-template.php */
		do_action( 'wp_body_open' );
	}
}

/**
 * Include a skip to content link at the top of the page so that users can bypass the menu.
 *
 * @since Twenty Twenty 1.0
 */
function twentytwenty_skip_link() {
	echo '<a class="skip-link screen-reader-text" href="#site-content">' . __( 'Skip to the content', 'twentytwenty' ) . '</a>';
}

add_action( 'wp_body_open', 'twentytwenty_skip_link', 5 );

/**
 * Register widget areas.
 *
 * @since Twenty Twenty 1.0
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function twentytwenty_sidebar_registration() {

	// Arguments used in all register_sidebar() calls.
	$shared_args = array(
		'before_title'  => '<h2 class="widget-title subheading heading-size-3">',
		'after_title'   => '</h2>',
		'before_widget' => '<div class="widget %2$s"><div class="widget-content">',
		'after_widget'  => '</div></div>',
	);

	// Footer #1.
	register_sidebar(
		array_merge(
			$shared_args,
			array(
				'name'        => __( 'Footer #1', 'twentytwenty' ),
				'id'          => 'sidebar-1',
				'description' => __( 'Widgets in this area will be displayed in the first column in the footer.', 'twentytwenty' ),
			)
		)
	);

	// Footer #2.
	register_sidebar(
		array_merge(
			$shared_args,
			array(
				'name'        => __( 'Footer #2', 'twentytwenty' ),
				'id'          => 'sidebar-2',
				'description' => __( 'Widgets in this area will be displayed in the second column in the footer.', 'twentytwenty' ),
			)
		)
	);

}

add_action( 'widgets_init', 'twentytwenty_sidebar_registration' );

/**
 * Enqueue supplemental block editor styles.
 *
 * @since Twenty Twenty 1.0
 */
function twentytwenty_block_editor_styles() {

	// Enqueue the editor styles.
	wp_enqueue_style( 'twentytwenty-block-editor-styles', get_theme_file_uri( '/assets/css/editor-style-block.css' ), array(), wp_get_theme()->get( 'Version' ), 'all' );
	wp_style_add_data( 'twentytwenty-block-editor-styles', 'rtl', 'replace' );

	// Add inline style from the Customizer.
	wp_add_inline_style( 'twentytwenty-block-editor-styles', twentytwenty_get_customizer_css( 'block-editor' ) );

	// Add inline style for non-latin fonts.
	wp_add_inline_style( 'twentytwenty-block-editor-styles', TwentyTwenty_Non_Latin_Languages::get_non_latin_css( 'block-editor' ) );

	// Enqueue the editor script.
	wp_enqueue_script( 'twentytwenty-block-editor-script', get_theme_file_uri( '/assets/js/editor-script-block.js' ), array( 'wp-blocks', 'wp-dom' ), wp_get_theme()->get( 'Version' ), true );
}

add_action( 'enqueue_block_editor_assets', 'twentytwenty_block_editor_styles', 1, 1 );

/**
 * Enqueue classic editor styles.
 *
 * @since Twenty Twenty 1.0
 */
function twentytwenty_classic_editor_styles() {

	$classic_editor_styles = array(
		'/assets/css/editor-style-classic.css',
	);

	add_editor_style( $classic_editor_styles );

}

add_action( 'init', 'twentytwenty_classic_editor_styles' );

/**
 * Output Customizer settings in the classic editor.
 * Adds styles to the head of the TinyMCE iframe. Kudos to @Otto42 for the original solution.
 *
 * @since Twenty Twenty 1.0
 *
 * @param array $mce_init TinyMCE styles.
 * @return array TinyMCE styles.
 */
function twentytwenty_add_classic_editor_customizer_styles( $mce_init ) {

	$styles = twentytwenty_get_customizer_css( 'classic-editor' );

	if ( ! isset( $mce_init['content_style'] ) ) {
		$mce_init['content_style'] = $styles . ' ';
	} else {
		$mce_init['content_style'] .= ' ' . $styles . ' ';
	}

	return $mce_init;

}

add_filter( 'tiny_mce_before_init', 'twentytwenty_add_classic_editor_customizer_styles' );

/**
 * Output non-latin font styles in the classic editor.
 * Adds styles to the head of the TinyMCE iframe. Kudos to @Otto42 for the original solution.
 *
 * @param array $mce_init TinyMCE styles.
 * @return array TinyMCE styles.
 */
function twentytwenty_add_classic_editor_non_latin_styles( $mce_init ) {

	$styles = TwentyTwenty_Non_Latin_Languages::get_non_latin_css( 'classic-editor' );

	// Return if there are no styles to add.
	if ( ! $styles ) {
		return $mce_init;
	}

	if ( ! isset( $mce_init['content_style'] ) ) {
		$mce_init['content_style'] = $styles . ' ';
	} else {
		$mce_init['content_style'] .= ' ' . $styles . ' ';
	}

	return $mce_init;

}

add_filter( 'tiny_mce_before_init', 'twentytwenty_add_classic_editor_non_latin_styles' );

/**
 * Block Editor Settings.
 * Add custom colors and font sizes to the block editor.
 *
 * @since Twenty Twenty 1.0
 */
function twentytwenty_block_editor_settings() {

	// Block Editor Palette.
	$editor_color_palette = array(
		array(
			'name'  => __( 'Accent Color', 'twentytwenty' ),
			'slug'  => 'accent',
			'color' => twentytwenty_get_color_for_area( 'content', 'accent' ),
		),
		array(
			'name'  => _x( 'Primary', 'color', 'twentytwenty' ),
			'slug'  => 'primary',
			'color' => twentytwenty_get_color_for_area( 'content', 'text' ),
		),
		array(
			'name'  => _x( 'Secondary', 'color', 'twentytwenty' ),
			'slug'  => 'secondary',
			'color' => twentytwenty_get_color_for_area( 'content', 'secondary' ),
		),
		array(
			'name'  => __( 'Subtle Background', 'twentytwenty' ),
			'slug'  => 'subtle-background',
			'color' => twentytwenty_get_color_for_area( 'content', 'borders' ),
		),
	);

	// Add the background option.
	$background_color = get_theme_mod( 'background_color' );
	if ( ! $background_color ) {
		$background_color_arr = get_theme_support( 'custom-background' );
		$background_color     = $background_color_arr[0]['default-color'];
	}
	$editor_color_palette[] = array(
		'name'  => __( 'Background Color', 'twentytwenty' ),
		'slug'  => 'background',
		'color' => '#' . $background_color,
	);

	// If we have accent colors, add them to the block editor palette.
	if ( $editor_color_palette ) {
		add_theme_support( 'editor-color-palette', $editor_color_palette );
	}

	// Block Editor Font Sizes.
	add_theme_support(
		'editor-font-sizes',
		array(
			array(
				'name'      => _x( 'Small', 'Name of the small font size in the block editor', 'twentytwenty' ),
				'shortName' => _x( 'S', 'Short name of the small font size in the block editor.', 'twentytwenty' ),
				'size'      => 18,
				'slug'      => 'small',
			),
			array(
				'name'      => _x( 'Regular', 'Name of the regular font size in the block editor', 'twentytwenty' ),
				'shortName' => _x( 'M', 'Short name of the regular font size in the block editor.', 'twentytwenty' ),
				'size'      => 21,
				'slug'      => 'normal',
			),
			array(
				'name'      => _x( 'Large', 'Name of the large font size in the block editor', 'twentytwenty' ),
				'shortName' => _x( 'L', 'Short name of the large font size in the block editor.', 'twentytwenty' ),
				'size'      => 26.25,
				'slug'      => 'large',
			),
			array(
				'name'      => _x( 'Larger', 'Name of the larger font size in the block editor', 'twentytwenty' ),
				'shortName' => _x( 'XL', 'Short name of the larger font size in the block editor.', 'twentytwenty' ),
				'size'      => 32,
				'slug'      => 'larger',
			),
		)
	);

	add_theme_support( 'editor-styles' );

	// If we have a dark background color then add support for dark editor style.
	// We can determine if the background color is dark by checking if the text-color is white.
	if ( '#ffffff' === strtolower( twentytwenty_get_color_for_area( 'content', 'text' ) ) ) {
		add_theme_support( 'dark-editor-style' );
	}

}

add_action( 'after_setup_theme', 'twentytwenty_block_editor_settings' );

/**
 * Overwrite default more tag with styling and screen reader markup.
 *
 * @param string $html The default output HTML for the more tag.
 * @return string
 */
function twentytwenty_read_more_tag( $html ) {
	return preg_replace( '/<a(.*)>(.*)<\/a>/iU', sprintf( '<div class="read-more-button-wrap"><a$1><span class="faux-button">$2</span> <span class="screen-reader-text">"%1$s"</span></a></div>', get_the_title( get_the_ID() ) ), $html );
}

add_filter( 'the_content_more_link', 'twentytwenty_read_more_tag' );

/**
 * Enqueues scripts for customizer controls & settings.
 *
 * @since Twenty Twenty 1.0
 *
 * @return void
 */
function twentytwenty_customize_controls_enqueue_scripts() {
	$theme_version = wp_get_theme()->get( 'Version' );

	// Add main customizer js file.
	wp_enqueue_script( 'twentytwenty-customize', get_template_directory_uri() . '/assets/js/customize.js', array( 'jquery' ), $theme_version, false );

	// Add script for color calculations.
	wp_enqueue_script( 'twentytwenty-color-calculations', get_template_directory_uri() . '/assets/js/color-calculations.js', array( 'wp-color-picker' ), $theme_version, false );

	// Add script for controls.
	wp_enqueue_script( 'twentytwenty-customize-controls', get_template_directory_uri() . '/assets/js/customize-controls.js', array( 'twentytwenty-color-calculations', 'customize-controls', 'underscore', 'jquery' ), $theme_version, false );
	wp_localize_script( 'twentytwenty-customize-controls', 'twentyTwentyBgColors', twentytwenty_get_customizer_color_vars() );
}

add_action( 'customize_controls_enqueue_scripts', 'twentytwenty_customize_controls_enqueue_scripts' );

/**
 * Enqueue scripts for the customizer preview.
 *
 * @since Twenty Twenty 1.0
 *
 * @return void
 */
function twentytwenty_customize_preview_init() {
	$theme_version = wp_get_theme()->get( 'Version' );

	wp_enqueue_script( 'twentytwenty-customize-preview', get_theme_file_uri( '/assets/js/customize-preview.js' ), array( 'customize-preview', 'customize-selective-refresh', 'jquery' ), $theme_version, true );
	wp_localize_script( 'twentytwenty-customize-preview', 'twentyTwentyBgColors', twentytwenty_get_customizer_color_vars() );
	wp_localize_script( 'twentytwenty-customize-preview', 'twentyTwentyPreviewEls', twentytwenty_get_elements_array() );

	wp_add_inline_script(
		'twentytwenty-customize-preview',
		sprintf(
			'wp.customize.selectiveRefresh.partialConstructor[ %1$s ].prototype.attrs = %2$s;',
			wp_json_encode( 'cover_opacity' ),
			wp_json_encode( twentytwenty_customize_opacity_range() )
		)
	);
}

add_action( 'customize_preview_init', 'twentytwenty_customize_preview_init' );

/**
 * Get accessible color for an area.
 *
 * @since Twenty Twenty 1.0
 *
 * @param string $area    The area we want to get the colors for.
 * @param string $context Can be 'text' or 'accent'.
 * @return string Returns a HEX color.
 */
function twentytwenty_get_color_for_area( $area = 'content', $context = 'text' ) {

	// Get the value from the theme-mod.
	$settings = get_theme_mod(
		'accent_accessible_colors',
		array(
			'content'       => array(
				'text'      => '#000000',
				'accent'    => '#cd2653',
				'secondary' => '#6d6d6d',
				'borders'   => '#dcd7ca',
			),
			'header-footer' => array(
				'text'      => '#000000',
				'accent'    => '#cd2653',
				'secondary' => '#6d6d6d',
				'borders'   => '#dcd7ca',
			),
		)
	);

	// If we have a value return it.
	if ( isset( $settings[ $area ] ) && isset( $settings[ $area ][ $context ] ) ) {
		return $settings[ $area ][ $context ];
	}

	// Return false if the option doesn't exist.
	return false;
}

/**
 * Returns an array of variables for the customizer preview.
 *
 * @since Twenty Twenty 1.0
 *
 * @return array
 */
function twentytwenty_get_customizer_color_vars() {
	$colors = array(
		'content'       => array(
			'setting' => 'background_color',
		),
		'header-footer' => array(
			'setting' => 'header_footer_background_color',
		),
	);
	return $colors;
}

/**
 * Get an array of elements.
 *
 * @since Twenty Twenty 1.0
 *
 * @return array
 */
function twentytwenty_get_elements_array() {

	// The array is formatted like this:
	// [key-in-saved-setting][sub-key-in-setting][css-property] = [elements].
	$elements = array(
		'content'       => array(
			'accent'     => array(
				'color'            => array( '.color-accent', '.color-accent-hover:hover', '.color-accent-hover:focus', ':root .has-accent-color', '.has-drop-cap:not(:focus):first-letter', '.wp-block-button.is-style-outline', 'a' ),
				'border-color'     => array( 'blockquote', '.border-color-accent', '.border-color-accent-hover:hover', '.border-color-accent-hover:focus' ),
				'background-color' => array( 'button', '.button', '.faux-button', '.wp-block-button__link', '.wp-block-file .wp-block-file__button', 'input[type="button"]', 'input[type="reset"]', 'input[type="submit"]', '.bg-accent', '.bg-accent-hover:hover', '.bg-accent-hover:focus', ':root .has-accent-background-color', '.comment-reply-link' ),
				'fill'             => array( '.fill-children-accent', '.fill-children-accent *' ),
			),
			'background' => array(
				'color'            => array( ':root .has-background-color', 'button', '.button', '.faux-button', '.wp-block-button__link', '.wp-block-file__button', 'input[type="button"]', 'input[type="reset"]', 'input[type="submit"]', '.wp-block-button', '.comment-reply-link', '.has-background.has-primary-background-color:not(.has-text-color)', '.has-background.has-primary-background-color *:not(.has-text-color)', '.has-background.has-accent-background-color:not(.has-text-color)', '.has-background.has-accent-background-color *:not(.has-text-color)' ),
				'background-color' => array( ':root .has-background-background-color' ),
			),
			'text'       => array(
				'color'            => array( 'body', '.entry-title a', ':root .has-primary-color' ),
				'background-color' => array( ':root .has-primary-background-color' ),
			),
			'secondary'  => array(
				'color'            => array( 'cite', 'figcaption', '.wp-caption-text', '.post-meta', '.entry-content .wp-block-archives li', '.entry-content .wp-block-categories li', '.entry-content .wp-block-latest-posts li', '.wp-block-latest-comments__comment-date', '.wp-block-latest-posts__post-date', '.wp-block-embed figcaption', '.wp-block-image figcaption', '.wp-block-pullquote cite', '.comment-metadata', '.comment-respond .comment-notes', '.comment-respond .logged-in-as', '.pagination .dots', '.entry-content hr:not(.has-background)', 'hr.styled-separator', ':root .has-secondary-color' ),
				'background-color' => array( ':root .has-secondary-background-color' ),
			),
			'borders'    => array(
				'border-color'        => array( 'pre', 'fieldset', 'input', 'textarea', 'table', 'table *', 'hr' ),
				'background-color'    => array( 'caption', 'code', 'code', 'kbd', 'samp', '.wp-block-table.is-style-stripes tbody tr:nth-child(odd)', ':root .has-subtle-background-background-color' ),
				'border-bottom-color' => array( '.wp-block-table.is-style-stripes' ),
				'border-top-color'    => array( '.wp-block-latest-posts.is-grid li' ),
				'color'               => array( ':root .has-subtle-background-color' ),
			),
		),
		'header-footer' => array(
			'accent'     => array(
				'color'            => array( 'body:not(.overlay-header) .primary-menu > li > a', 'body:not(.overlay-header) .primary-menu > li > .icon', '.modal-menu a', '.footer-menu a, .footer-widgets a', '#site-footer .wp-block-button.is-style-outline', '.wp-block-pullquote:before', '.singular:not(.overlay-header) .entry-header a', '.archive-header a', '.header-footer-group .color-accent', '.header-footer-group .color-accent-hover:hover' ),
				'background-color' => array( '.social-icons a', '#site-footer button:not(.toggle)', '#site-footer .button', '#site-footer .faux-button', '#site-footer .wp-block-button__link', '#site-footer .wp-block-file__button', '#site-footer input[type="button"]', '#site-footer input[type="reset"]', '#site-footer input[type="submit"]' ),
			),
			'background' => array(
				'color'            => array( '.social-icons a', 'body:not(.overlay-header) .primary-menu ul', '.header-footer-group button', '.header-footer-group .button', '.header-footer-group .faux-button', '.header-footer-group .wp-block-button:not(.is-style-outline) .wp-block-button__link', '.header-footer-group .wp-block-file__button', '.header-footer-group input[type="button"]', '.header-footer-group input[type="reset"]', '.header-footer-group input[type="submit"]' ),
				'background-color' => array( '#site-header', '.footer-nav-widgets-wrapper', '#site-footer', '.menu-modal', '.menu-modal-inner', '.search-modal-inner', '.archive-header', '.singular .entry-header', '.singular .featured-media:before', '.wp-block-pullquote:before' ),
			),
			'text'       => array(
				'color'               => array( '.header-footer-group', 'body:not(.overlay-header) #site-header .toggle', '.menu-modal .toggle' ),
				'background-color'    => array( 'body:not(.overlay-header) .primary-menu ul' ),
				'border-bottom-color' => array( 'body:not(.overlay-header) .primary-menu > li > ul:after' ),
				'border-left-color'   => array( 'body:not(.overlay-header) .primary-menu ul ul:after' ),
			),
			'secondary'  => array(
				'color' => array( '.site-description', 'body:not(.overlay-header) .toggle-inner .toggle-text', '.widget .post-date', '.widget .rss-date', '.widget_archive li', '.widget_categories li', '.widget cite', '.widget_pages li', '.widget_meta li', '.widget_nav_menu li', '.powered-by-wordpress', '.to-the-top', '.singular .entry-header .post-meta', '.singular:not(.overlay-header) .entry-header .post-meta a' ),
			),
			'borders'    => array(
				'border-color'     => array( '.header-footer-group pre', '.header-footer-group fieldset', '.header-footer-group input', '.header-footer-group textarea', '.header-footer-group table', '.header-footer-group table *', '.footer-nav-widgets-wrapper', '#site-footer', '.menu-modal nav *', '.footer-widgets-outer-wrapper', '.footer-top' ),
				'background-color' => array( '.header-footer-group table caption', 'body:not(.overlay-header) .header-inner .toggle-wrapper::before' ),
			),
		),
	);

	/**
	 * Filters Twenty Twenty theme elements.
	 *
	 * @since Twenty Twenty 1.0
	 *
	 * @param array Array of elements.
	 */
	return apply_filters( 'twentytwenty_get_elements_array', $elements );
}
