        <?php $header = get_field('header','options'); ?>
        <div class="offcanvas offcanvas-start" tabindex="-1" id="offcv" >
            <div class="offcanvas-header">
                <button class="btn-close text-reset" type="button" aria-label="Botão para fechar menu para celulares" data-bs-dismiss="offcanvas"></button>
            </div>
            <div class="offcanvas-body">
                <div>
                    <div class="logo">
                        <?= get_custom_logo(); ?>
                    </div>
                    <?= wp_nav_menu(); ?>
                </div>
                <div class="boxes">
                    <?php if(!empty($header['tels'])): ?>
                        <div class="df tels">
                            <?php foreach($header['tels'] as $tel): ?>
                                <a href="tel:55<?= preg_replace('/\D/', '', $tel['tel']); ?>" class="telp" aria-label="<?= strlen(preg_replace('/\D/', '', $tel['tel']))>10 ? 'WhatsApp' : 'Telefone'; ?> <?= $tel['tel']; ?>" ><?= $tel['tel']; ?></a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty($header['zaps'])): ?>
                        <div class="df zaps">
                            <?php foreach($header['zaps'] as $zap): ?>
                                <a href="https://api.whatsapp.com/send?l=pt_br&amp;phone=55<?= preg_replace('/\D/', '', $zap['zap']); ?>" class="telp zap" aria-label="<?= strlen(preg_replace('/\D/', '', $zap['zap']))>10 ? 'WhatsApp' : 'Telefone'; ?> <?= $zap['zap']; ?>" ><?= $zap['zap']; ?></a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty($header['mails'])): ?>
                        <div class="df mails">
                            <?php foreach($header['mails'] as $mail): ?>
                                <a href="mailto:<?= !empty($mail['mail']) ? $mail['mail'] : '' ?>" class="mailp" aria-label="E-mail <?= !empty($mail['mail']) ? $mail['mail'] : '' ?>"><?= !empty($mail['mail']) ? $mail['mail'] : '' ?></a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php $footer = get_field('footer','options'); ?>

        <footer>
            <div class="footer1">
                <div class="container">
                    <div class="row">
                        <?php if(!empty($footer['logo'])): ?>
                            <div class="col-lg-4">
                                <a href="<?= site_url() ?>" class="logo" aria-label="Home do Site">
                                    <img src="<?= $footer['logo']; ?>" loading="lazy" alt="Logotipo Empresa">
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($footer['follow'])): ?>
                            <div class="col-lg-4 c2">
                                <div class="follow">
                                    <?= $footer['follow']; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($footer['rss'])): ?>
                            <div class="col-lg-4">
                                <div class="rss">
                                    <?php foreach($footer['rss'] as $rede): ?>
                                        <a href="<?= !empty($rede['link']) ? $rede['link'] : ''; ?>" target="_blank" class="rs" aria-label="Rede Social <?= getRssName($rede['whichrede']); ?>">
                                            <?= getRss($rede['whichrede']); ?>
                                        </a>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="footer2">
                <div class="container">
                    <div class="row">
                        <?php if(!empty($footer['sitemap'])): ?>
                            <div class="col-lg-3 c1">
                                <div class="stitle">Mapa do Site</div>
                                <ul>
                                    <?php foreach($footer['sitemap'] as $page): ?>
                                        <li><a href="<?= !empty($page['page']) ? $page['page'] : '#'; ?>" aria-label="Link para a Página <?= !empty($page['name']) ? $page['name'] : ''; ?>"><?= !empty($page['name']) ? $page['name'] : ''; ?></a></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <div class="col-lg-3 c2">
                            <div class="stitle">Serviços</div>
                            <?php if(!empty($footer['prds'])): ?>
                                <ul>
                                    <?php foreach($footer['prds'] as $prd): ?>
                                        <li><a href="<?= get_the_permalink($prd->ID); ?>"><?= get_the_title($prd->ID); ?></a></li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-3 c3">
                            <?php if(!empty($footer['contatos'])): ?>
                                <div class="stitle">Contatos</div>
                                <?php foreach($footer['contatos'] as $contato): ?>
                                    <?php if($contato['contype']=='tel'): ?>
                                        <a href="<?= strlen(preg_replace('/\D/', '', $contato['texto']))>10 ? 'https://api.whatsapp.com/send?l=pt_br&amp;phone=55' : 'tel:55'; ?><?= preg_replace('/\D/', '', $contato['texto']); ?>" <?= strlen(preg_replace('/\D/', '', $contato['texto']))>10 ? 'target="_blank"' : ''; ?> class="telp" aria-label="<?= strlen(preg_replace('/\D/', '', $contato['texto']))>10 ? 'WhatsApp' : 'Telefone'; ?> <?= $contato['texto']; ?>">
                                            <?= $contato['texto']; ?>
                                        </a>
                                    <?php else: ?>
                                        <a class="mailp" href="mailto:<?= $contato['texto']; ?>" aria-label="E-mail <?= $contato['texto']; ?>">
                                            <?= $contato['texto']; ?>
                                        </a>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            <?php endif; ?>
                            <?php if(!empty($footer['hour'])): ?>
                                <div class="stitle st-lg">Horário</div>
                                <div class="hour">
                                    <?= $footer['hour']; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php if(!empty($footer['local'])): ?>
                            <div class="col-lg-3 c4">
                                <div class="stitle">Localização</div>
                                <div class="local">
                                    <?php if(!empty($footer['map'])): ?>
                                        <a href="<?= $footer['map']; ?>" class="map" aria-label="Link para o Google Maps da Empresa"><img src="<?= get_template_directory_uri(); ?>/assets/img/map.svg" alt=""></a>
                                    <?php endif; ?>
                                    <?= $footer['local']; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="footer-design">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-7">
                            <div class="d-inline-flex">
                                <?php $linkt = $footer['islink']; ?>
                                <?php if($linkt=='in'): ?>
                                    <?php $in = $footer['linkin']; ?>
                                <?php else: ?>
                                    <?php $out = $footer['linkout']; ?>
                                <?php endif; ?>
                                <a href="<?= $linkt=='in' ? $in : $out; ?>" class="lgpd" target="_blank" aria-label="Link para a LGPD">
                                    <style>
                                        .lgpd{background-color: <?= $footer['lgpdbg']; ?>;color: <?= $footer['lgpdfc']; ?> !important;}
                                    </style>
                                    <svg width="21" height="24" viewBox="0 0 21 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.5 19.3118C10.3275 19.3122 10.1567 19.2785 9.9973 19.2127C9.83789 19.147 9.69303 19.0504 9.57104 18.9285C9.44905 18.8066 9.35233 18.6618 9.28643 18.5024C9.22052 18.3431 9.18674 18.1722 9.187 17.9998V14.9998C9.187 14.6517 9.32528 14.3179 9.57142 14.0717C9.81756 13.8256 10.1514 13.6873 10.4995 13.6873C10.8476 13.6873 11.1814 13.8256 11.4276 14.0717C11.6737 14.3179 11.812 14.6517 11.812 14.9998V17.9998C11.8123 18.1722 11.7785 18.3429 11.7127 18.5022C11.6468 18.6615 11.5502 18.8062 11.4283 18.9281C11.3064 19.05 11.1617 19.1466 11.0024 19.2125C10.8431 19.2783 10.6724 19.3121 10.5 19.3118ZM21 11.2498V21.7498C20.9997 22.3465 20.7626 22.9186 20.3407 23.3405C19.9188 23.7624 19.3467 23.9995 18.75 23.9998H2.25C1.65334 23.9995 1.0812 23.7624 0.659302 23.3405C0.237403 22.9186 0.000265004 22.3465 0 21.7498L0 11.2498C0.000265004 10.6531 0.237403 10.081 0.659302 9.6591C1.0812 9.2372 1.65334 9.00006 2.25 8.9998H3.75V6.7498C3.75433 5.86337 3.93322 4.98648 4.27644 4.16919C4.61966 3.3519 5.1205 2.61022 5.75036 1.98649C6.38022 1.36276 7.12677 0.869196 7.94737 0.53398C8.76798 0.198765 9.64658 0.0284619 10.533 0.0327955C11.4194 0.0371291 12.2963 0.216014 13.1136 0.559237C13.9309 0.90246 14.6726 1.4033 15.2963 2.03316C15.92 2.66302 16.4136 3.40956 16.7488 4.23017C17.084 5.05078 17.2543 5.92937 17.25 6.8158V8.9998H18.75C19.3467 9.00006 19.9188 9.2372 20.3407 9.6591C20.7626 10.081 20.9997 10.6531 21 11.2498ZM6 8.9998H15V6.7498C15 6.15885 14.8836 5.57369 14.6575 5.02772C14.4313 4.48175 14.0998 3.98568 13.682 3.56782C13.2641 3.14995 12.768 2.81848 12.2221 2.59234C11.6761 2.36619 11.0909 2.2498 10.5 2.2498C9.90905 2.2498 9.32389 2.36619 8.77792 2.59234C8.23196 2.81848 7.73588 3.14995 7.31802 3.56782C6.90016 3.98568 6.56869 4.48175 6.34254 5.02772C6.1164 5.57369 6 6.15885 6 6.7498V8.9998ZM18.75 11.2498H2.25V21.7498H18.75V11.2498Z" fill="<?= $footer['lgpdic']; ?>"/></svg>
                                    LGPD
                                </a>
                                <div class="site">
                                    <div class="sitetitle">
                                        <strong><?= get_bloginfo('name'); ?>&nbsp;<?= get_bloginfo('description'); ?></strong>, 2025 - <?= current_time('Y'); ?>
                                    </div>
                                    <?php if(!empty($footer['da'])): ?>
                                        <div class="text">
                                            <?= $footer['da']; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5 c2">
                            <div class="design">
                                Desenvolvido por:&nbsp;<a href="https://visualy.com.br" target="_blank" aria-label="Link para o Site da Visualy">Visualy Publicidade</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </footer>

        <?= wp_footer(); ?>

        <!-- JS -->
        <script defer type="text/javascript" src="<?= get_template_directory_uri() ?>/custom/js/jquery.min.js"></script>

        <script defer type="text/javascript" src="<?= get_template_directory_uri() ?>/assets/library/fslightbox/fslightbox.js"></script>

        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js" integrity="sha384-7+zCNj/IqJ95wo16oMtfsKbZ9ccEh31eOz1HGyDuCQ6wgnyJNSYdrPa03rtR1zdB" crossorigin="anonymous"></script>
        <script defer type="text/javascript" src="<?= get_template_directory_uri() ?>/assets/library/bootstrap/js/bootstrap.min.js"></script>

        <script defer type="text/javascript" src="<?= get_template_directory_uri() ?>/assets/library/OwlCarousel/dist/owl.carousel.min.js"></script>
        
        <!-- <script defer type="text/javascript" src="<?php //get_template_directory_uri() ?>/assets/library/mask/dist/jquery.mask.min.js"></script> -->

        <script defer type="text/javascript" src="<?= get_template_directory_uri() ?>/custom/js/all.js"></script>
    </body>
</hmtl>
