<?php /** Template Name: Serviços */ ?>
<?= get_header(); ?>
<link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/archive-servicos.css">
<link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/archive-servicos.css">

<?php $serv = get_field('serv',88); ?>

<section class="archive-sols">
    <div class="container">
        <?php if(!empty($serv['title'])): ?>
            <div class="sectitle text-center mb-5"><?= $serv['title']; ?></div>
        <?php endif; ?>
        <div class="row">
            <?php if(have_posts()): ?>
                <?php while(have_posts()): the_post(); $serv = get_field('servico'); ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="box">
                            <div class="title"><?= get_the_title(); ?></div>
                            <?php if(!empty($serv['text'])): ?>
                                <div class="text"><?= encurta(strip_tags($serv['text']),150); ?></div>
                            <?php endif; ?>
                            <div class="df">
                                <a href="<?= get_the_permalink(); ?>" class="lm"></a>
                                <?php if(!empty($serv['icon'])): ?>
                                    <img src="<?= esc_url($serv['icon']['url']); ?>" loading="lazy" alt="<?= esc_attr($serv['icon']['alt']); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
                <div class="col-12">
                    <?= pagination(); ?>
                </div>
            <?php else: ?>
                <div class="col-12">
                    <div class="sectitle"><?= get_queried_object()->labels->not_found; ?></div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<?= get_footer(); ?>

<script>
    for(let i of document.querySelectorAll('.sticky .menu>*')){
        if(i.firstChild.text=='Serviços'){
            i.classList.add('current-menu-item');
        }
    }
</script>

<script>
    document.querySelector('section.ban .title').textContent = '<?= get_the_title(88) ?>';
</script>

<script>
    let maxHeight=0;
    document.querySelectorAll('.archive-sols .box .title').forEach(function(e) {
    if (e.offsetHeight > maxHeight) {
        maxHeight = e.offsetHeight;
    }
    });
    document.querySelectorAll('.archive-sols .box .title').forEach(function(e) {
        e.style.height = maxHeight + 'px';
    });
    maxHeight=0;
    document.querySelectorAll('.archive-sols .box .text').forEach(function(e) {
    if (e.offsetHeight > maxHeight) {
        maxHeight = e.offsetHeight;
    }
    });
    document.querySelectorAll('.archive-sols .box .text').forEach(function(e) {
        e.style.height = maxHeight + 'px';
    });
</script>