<?php /** Template Name: Blog */ ?>
<?= get_header(); ?>
<link rel="stylesheet" href="<?= get_template_directory_uri() ?>/custom/css/archive-blog.css">
<link rel="preload" as="style" href="<?= get_template_directory_uri() ?>/custom/css/archive-blog.css">

<?php $title = get_field('title',94); ?>

<section class="archive-blg">
    <?php if(!empty($title)): ?>
        <div class="df">
            <div class="sectitle"><?= $title; ?></div>
        </div>
    <?php endif; ?>
    <div class="container">
        <div class="row">
            <?php if(have_posts()): ?>
                <?php while(have_posts()): the_post(); $b = get_field('blog'); ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="box">
                            <div class="img">
                                <?php if(!empty($b['img'])): ?>
                                    <img src="<?= esc_url($b['img']['url']); ?>" loading="lazy" alt="<?= esc_attr($b['img']['alt']); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="bottom">
                                <div class="title"><?= get_the_title(); ?></div>
                                <a href="<?= get_the_permalink(); ?>" class="lm"></a>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
                <div class="col-12">
                    <?= pagination(); ?>
                </div>
            <?php else: ?>
                <div class="col-12">
                    <div class="sectitle"><?= get_queried_object()->labels->not_found; ?></div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<?= get_footer(); ?>

<script>
    for(let i of document.querySelectorAll('.sticky .menu>*')){
        if(i.firstChild.text=='Blog'){
            i.classList.add('current-menu-item');
        }
    }
</script>

<script>
    let maxHeight=0;
    document.querySelectorAll('.archive-blg .box .title').forEach(function(e) {
    if (e.offsetHeight > maxHeight) {
        maxHeight = e.offsetHeight;
    }
    });
    document.querySelectorAll('.archive-blg .box .title').forEach(function(e) {
        e.style.height = maxHeight + 'px';
    });
</script>